/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.wrapper.play.server;

import java.util.Objects;
import net.craftsupport.anticrasher.packetevents.api.event.PacketSendEvent;
import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerVersion;
import net.craftsupport.anticrasher.packetevents.api.protocol.packettype.PacketType;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import net.craftsupport.anticrasher.packetevents.impl.adventure.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerTitle
extends PacketWrapper<WrapperPlayServerTitle> {
    @Deprecated
    public static boolean HANDLE_JSON = true;
    private TitleAction action;
    @Nullable
    private Component title;
    @Nullable
    private Component subtitle;
    @Nullable
    private Component actionBar;
    private int fadeInTicks;
    private int stayTicks;
    private int fadeOutTicks;

    public WrapperPlayServerTitle(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerTitle(TitleAction action, @Nullable Component title, @Nullable Component subtitle, @Nullable Component actionBar, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super(PacketType.Play.Server.TITLE);
        this.action = action;
        this.title = title;
        this.subtitle = subtitle;
        this.actionBar = actionBar;
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    @Deprecated
    public WrapperPlayServerTitle(TitleAction action, @Nullable String titleJson, @Nullable String subtitleJson, @Nullable String actionBarJson, int fadeInTicks, int stayTicks, int fadeOutTicks) {
        super(PacketType.Play.Server.TITLE);
        this.action = action;
        GsonComponentSerializer gson = this.getSerializers().gson();
        this.title = gson.deserializeOrNull(titleJson);
        this.subtitle = gson.deserializeOrNull(subtitleJson);
        this.actionBar = gson.deserializeOrNull(actionBarJson);
        this.fadeInTicks = fadeInTicks;
        this.stayTicks = stayTicks;
        this.fadeOutTicks = fadeOutTicks;
    }

    @Override
    public void read() {
        boolean modern = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11);
        int id = this.readVarInt();
        this.action = modern ? TitleAction.fromId(id) : TitleAction.fromLegacyId(id);
        switch (Objects.requireNonNull(this.action).ordinal()) {
            case 0: {
                this.title = this.readComponent();
                break;
            }
            case 1: {
                this.subtitle = this.readComponent();
                break;
            }
            case 2: {
                this.actionBar = this.readComponent();
                break;
            }
            case 3: {
                this.fadeInTicks = this.readInt();
                this.stayTicks = this.readInt();
                this.fadeOutTicks = this.readInt();
            }
        }
    }

    @Override
    public void copy(WrapperPlayServerTitle wrapper) {
        this.action = wrapper.action;
        this.title = wrapper.title;
        this.subtitle = wrapper.subtitle;
        this.actionBar = wrapper.actionBar;
        this.fadeInTicks = wrapper.fadeInTicks;
        this.stayTicks = wrapper.stayTicks;
        this.fadeOutTicks = wrapper.fadeOutTicks;
    }

    @Override
    public void write() {
        boolean modern = this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_11);
        int id = modern ? this.action.getId() : this.action.getLegacyId();
        this.writeVarInt(id);
        switch (this.action.ordinal()) {
            case 0: {
                this.writeComponent(this.title);
                break;
            }
            case 1: {
                this.writeComponent(this.subtitle);
                break;
            }
            case 2: {
                this.writeComponent(this.actionBar);
                break;
            }
            case 3: {
                this.writeInt(this.fadeInTicks);
                this.writeInt(this.stayTicks);
                this.writeInt(this.fadeOutTicks);
            }
        }
    }

    public TitleAction getAction() {
        return this.action;
    }

    public void setAction(TitleAction action) {
        this.action = action;
    }

    @Nullable
    public Component getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable Component title) {
        this.title = title;
    }

    @Deprecated
    @Nullable
    public String getTitleJson() {
        return this.getSerializers().asJson(this.getTitle());
    }

    @Deprecated
    public void setTitleJson(@Nullable String titleJson) {
        this.setTitle(this.getSerializers().fromJson(titleJson));
    }

    @Nullable
    public Component getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(@Nullable Component subtitle) {
        this.subtitle = subtitle;
    }

    @Deprecated
    @Nullable
    public String getSubtitleJson() {
        return this.getSerializers().asJson(this.getSubtitle());
    }

    @Deprecated
    public void setSubtitleJson(@Nullable String subtitleJson) {
        this.setSubtitle(this.getSerializers().fromJson(subtitleJson));
    }

    @Nullable
    public Component getActionBar() {
        return this.actionBar;
    }

    public void setActionBar(@Nullable Component actionBar) {
        this.actionBar = actionBar;
    }

    @Deprecated
    @Nullable
    public String getActionBarJson() {
        return this.getSerializers().asJson(this.getActionBar());
    }

    @Deprecated
    public void setActionBarJson(@Nullable String actionBarJson) {
        this.setActionBar(this.getSerializers().fromJson(actionBarJson));
    }

    public int getFadeInTicks() {
        return this.fadeInTicks;
    }

    public void setFadeInTicks(int fadeInTicks) {
        this.fadeInTicks = fadeInTicks;
    }

    public int getStayTicks() {
        return this.stayTicks;
    }

    public void setStayTicks(int stayTicks) {
        this.stayTicks = stayTicks;
    }

    public int getFadeOutTicks() {
        return this.fadeOutTicks;
    }

    public void setFadeOutTicks(int fadeOutTicks) {
        this.fadeOutTicks = fadeOutTicks;
    }

    public static enum TitleAction {
        SET_TITLE(0),
        SET_SUBTITLE(1),
        SET_ACTION_BAR,
        SET_TIMES_AND_DISPLAY(2),
        HIDE(3),
        RESET(4);

        private final int legacyId;

        private TitleAction() {
            this(-1);
        }

        private TitleAction(int legacyId) {
            this.legacyId = legacyId;
        }

        public static TitleAction fromId(int id) {
            return TitleAction.values()[id];
        }

        public static TitleAction fromLegacyId(int legacyId) {
            for (TitleAction action : TitleAction.values()) {
                if (action.legacyId != legacyId) continue;
                return action;
            }
            return null;
        }

        public int getId() {
            return this.ordinal();
        }

        public int getLegacyId() {
            return this.legacyId;
        }
    }
}

