/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.impl.handlers;

import com.velocitypowered.api.proxy.Player;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.api.event.PacketSendEvent;
import net.craftsupport.anticrasher.packetevents.api.netty.buffer.ByteBufHelper;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.User;
import net.craftsupport.anticrasher.packetevents.api.util.EventCreationUtil;

@ChannelHandler.Sharable
public class PacketEventsEncoder
extends MessageToByteEncoder<ByteBuf> {
    public Player player;
    public User user;

    public PacketEventsEncoder(User user) {
        this.user = user;
    }

    public void read(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        int firstReaderIndex = buffer.readerIndex();
        PacketSendEvent packetSendEvent = EventCreationUtil.createSendEvent(ctx.channel(), this.user, this.player, buffer, false);
        int readerIndex = buffer.readerIndex();
        PacketEvents.getAPI().getEventManager().callEvent(packetSendEvent, () -> buffer.readerIndex(readerIndex));
        if (!packetSendEvent.isCancelled()) {
            if (packetSendEvent.getLastUsedWrapper() != null) {
                ByteBufHelper.clear(packetSendEvent.getByteBuf());
                packetSendEvent.getLastUsedWrapper().writeVarInt(packetSendEvent.getPacketId());
                packetSendEvent.getLastUsedWrapper().write();
            }
            buffer.readerIndex(firstReaderIndex);
        } else {
            ByteBufHelper.clear(packetSendEvent.getByteBuf());
        }
        if (packetSendEvent.hasPostTasks()) {
            for (Runnable task : packetSendEvent.getPostTasks()) {
                task.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) throws Exception {
        if (!msg.isReadable()) {
            return;
        }
        ByteBuf transformed = ctx.alloc().buffer().writeBytes(msg);
        try {
            this.read(ctx, transformed);
            out.writeBytes(transformed);
        }
        finally {
            transformed.release();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
    }
}

