/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.anticrasher.velocity.user;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.List;
import java.util.UUID;
import net.craftsupport.anticrasher.api.util.objects.Tuple;
import net.craftsupport.anticrasher.common.util.TextUtil;
import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.User;
import net.kyori.adventure.text.Component;
import net.skullian.anticrasher.velocity.AntiCrasher;

public class VelocityUser
extends net.craftsupport.anticrasher.api.user.User {
    private final User user;
    private final UUID uuid;
    private final CommandSource source;
    private final boolean bypass;

    public VelocityUser(UUID uuid, Object source) {
        Player player = AntiCrasher.getInstance().server.getPlayer(uuid).orElse(null);
        this.user = player != null ? PacketEvents.getAPI().getPlayerManager().getUser(player) : null;
        this.uuid = uuid;
        this.source = (CommandSource)source;
        this.bypass = this.source != null && this.source.hasPermission("anticrasher.bypass");
    }

    @Override
    public String getName() {
        Player player = this.asPlayer();
        return player != null ? player.getUsername() : this.getUniqueId().toString();
    }

    @Override
    @SafeVarargs
    public final void sendMessage(String message, Tuple<String, Object> ... args) {
        this.source.sendMessage(TextUtil.text(message, args));
    }

    @Override
    @SafeVarargs
    public final void sendMessage(List<String> message, Tuple<String, Object> ... args) {
        this.source.sendMessage(TextUtil.text(message, args));
    }

    @Override
    public void sendMessage(Component component) {
        this.source.sendMessage(component);
    }

    @Override
    public boolean hasPermission(String permissionNode) {
        return this.source.hasPermission(permissionNode);
    }

    @Override
    public User toPE() {
        return this.user;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public String processPlaceholders(String message) {
        return message;
    }

    @Override
    public boolean shouldBypass() {
        return this.bypass;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    private Player asPlayer() {
        return this.source instanceof Player ? (Player)this.source : null;
    }
}

