/*
 * Decompiled with CFR 0.152.
 */
package net.skullian.anticrasher.velocity.user;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.craftsupport.anticrasher.api.user.User;
import net.craftsupport.anticrasher.api.user.UserManager;
import net.skullian.anticrasher.velocity.user.VelocityUser;
import org.jetbrains.annotations.NotNull;

public class VelocityUserManager
implements UserManager {
    private final Map<UUID, User> userCache = new ConcurrentHashMap<UUID, User>();

    @Override
    public User get(UUID uuid) {
        if (uuid == null) {
            return new VelocityUser(UUID.randomUUID(), null);
        }
        return this.userCache.get(uuid);
    }

    @Override
    @NotNull
    public User getOrCreate(UUID uuid, Object source) {
        return this.userCache.containsKey(uuid) ? this.get(uuid) : this.create(uuid, source);
    }

    @Override
    public User create(UUID uuid, Object source) {
        return this.userCache.computeIfAbsent(uuid, id -> new VelocityUser((UUID)id, source));
    }

    @Override
    public void invalidate(UUID uuid) {
        this.userCache.remove(uuid);
    }

    @Override
    public Collection<User> getOnlineUsers() {
        return this.userCache.values();
    }
}

