/*
 * Decompiled with CFR 0.152.
 */
package de.exlll.configlib;

import de.exlll.configlib.Comment;
import de.exlll.configlib.CommentNode;
import de.exlll.configlib.ConfigurationElement;
import de.exlll.configlib.ConfigurationElements;
import de.exlll.configlib.ConfigurationProperties;
import de.exlll.configlib.FieldExtractors;
import de.exlll.configlib.FieldFilter;
import de.exlll.configlib.NameFormatter;
import de.exlll.configlib.Reflect;
import de.exlll.configlib.Validator;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Queue;

final class CommentNodeExtractor {
    private final FieldFilter fieldFilter;
    private final NameFormatter nameFormatter;
    private final boolean outputNull;

    CommentNodeExtractor(ConfigurationProperties properties) {
        this.fieldFilter = Validator.requireNonNull(properties.getFieldFilter(), "field filter");
        this.nameFormatter = Validator.requireNonNull(properties.getNameFormatter(), "name formatter");
        this.outputNull = properties.outputNulls();
    }

    public Queue<CommentNode> extractCommentNodes(Object elementHolder) {
        Validator.requireConfigurationType(elementHolder.getClass());
        ArrayDeque<CommentNode> result = new ArrayDeque<CommentNode>();
        ArrayDeque<String> elementNameStack = new ArrayDeque<String>(List.of(""));
        ArrayDeque<State> stateStack = new ArrayDeque<State>(List.of(this.stateFromObject(elementHolder)));
        while (!stateStack.isEmpty()) {
            State state = stateStack.removeLast();
            elementNameStack.removeLast();
            while (state.iterator.hasNext()) {
                ConfigurationElement<?> element = state.iterator.next();
                Object elementValue = element.value(state.elementHolder);
                if (elementValue == null && !this.outputNull) continue;
                String elementName = element.name();
                Optional<CommentNode> commentNode = this.createNodeIfCommentPresent((AnnotatedElement)element.element(), elementName, (Deque<String>)elementNameStack);
                commentNode.ifPresent(result::add);
                Class<?> elementType = element.type();
                if (elementValue == null || !Reflect.isConfigurationType(elementType)) continue;
                stateStack.addLast(state);
                elementNameStack.addLast(this.nameFormatter.format(elementName));
                state = this.stateFromObject(elementValue);
            }
        }
        return result;
    }

    private State stateFromObject(Object elementHolder) {
        Class<?> type = elementHolder.getClass();
        Iterator<Record> iter = type.isRecord() ? this.recordComponentElements(elementHolder) : this.fieldElements(elementHolder);
        return new State(iter, elementHolder);
    }

    private Optional<CommentNode> createNodeIfCommentPresent(AnnotatedElement element, String elementName, Deque<String> elementNameStack) {
        if (element.isAnnotationPresent(Comment.class)) {
            List<String> comments = Arrays.stream(element.getAnnotation(Comment.class).value()).flatMap(s -> Arrays.stream(s.split("\n", -1))).toList();
            String formattedName = this.nameFormatter.format(elementName);
            ArrayList<String> elementNames = new ArrayList<String>(elementNameStack);
            elementNames.add(formattedName);
            CommentNode result = new CommentNode(comments, elementNames);
            return Optional.of(result);
        }
        return Optional.empty();
    }

    private Iterator<ConfigurationElements.FieldElement> fieldElements(Object configuration) {
        return FieldExtractors.CONFIGURATION.extract(configuration.getClass()).filter(this.fieldFilter).map(ConfigurationElements.FieldElement::new).iterator();
    }

    private Iterator<ConfigurationElements.RecordComponentElement> recordComponentElements(Object record) {
        return Arrays.stream(record.getClass().getRecordComponents()).map(ConfigurationElements.RecordComponentElement::new).iterator();
    }

    private record State(Iterator<? extends ConfigurationElement<?>> iterator, Object elementHolder) {
    }
}

