/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.api;

import net.craftsupport.anticrasher.api.Platform;
import net.craftsupport.anticrasher.api.event.bus.EventBus;
import net.craftsupport.anticrasher.api.user.UserManager;
import org.jetbrains.annotations.ApiStatus;

public abstract class AntiCrasherAPI {
    private static AntiCrasherAPI instance;

    public abstract Platform getPlatform();

    public abstract UserManager getUserManager();

    public abstract EventBus getEventBus();

    public static AntiCrasherAPI getInstance() {
        if (instance == null) {
            throw new IllegalStateException("The AntiCrasher API has not been initialized yet.\nMake sure of the following things:\n1. AntiCrasher has loaded before your plugin / mod:\n    - For Fabric: Make sure you have `AntiCrasher` added to your `depends` or `suggests` in `fabric.mod.json`.\n    - For Spigot/Paper: Make sure you have `AntiCrasher` added to your `softdepend` or `depend` in `plugin.yml`.\n2. You have not implemented/shaded the AntiCrasher API:\n    - For Gradle: Make sure you are using `compileOnly` instead of `implementation` in your build.gradle(.kts).\n    - For Maven: Make sure you are using `<scope>provided</scope>` instead of `<scope>compile</scope>` in your pom.xml.\n3. You are not calling AntiCrasherAPI#getInstance() before it has loaded.\n    - For Spigot/Paper: The API instance is only set on AntiCrasher's onEnable() method. If you try access it before (e.g. onLoad()), it will fail.\n    - For Fabric: Th API instance is only set on AntiCrasher's onInitialize() method.\n".stripIndent());
        }
        return instance;
    }

    @ApiStatus.Internal
    public static void setInstance(AntiCrasherAPI apiInstance) {
        if (instance != null) {
            throw new IllegalStateException("The AntiCrasherAPI instance has already been set!\nIf you are seeing this, then another plugin is attempting to call setInstance, when AntiCrasher has already set it.\n\nThis is a bug, and you should report it to any plugin that hooks into AntiCrasher.\n");
        }
        instance = apiInstance;
    }
}

