/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.bukkit;

import com.github.puregero.multilib.MultiLib;
import info.preva1l.trashcan.Version;
import info.preva1l.trashcan.flavor.Flavor;
import info.preva1l.trashcan.flavor.FlavorOptions;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import net.craftsupport.anticrasher.api.AntiCrasherAPI;
import net.craftsupport.anticrasher.api.Platform;
import net.craftsupport.anticrasher.api.user.User;
import net.craftsupport.anticrasher.bukkit.api.BukkitAntiCrasherAPI;
import net.craftsupport.anticrasher.bukkit.listener.PlayerEvents;
import net.craftsupport.anticrasher.bukkit.user.BukkitUser;
import net.craftsupport.anticrasher.common.manager.CheckManager;
import net.craftsupport.anticrasher.common.util.ACLogger;
import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.impl.bstats.bukkit.Metrics;
import net.craftsupport.anticrasher.packetevents.impl.factory.spigot.SpigotPacketEventsBuilder;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class AntiCrasher
extends JavaPlugin
implements Platform {
    public static AntiCrasher instance;
    private User consoleUser;
    protected Flavor flavor;

    public AntiCrasher() {
        instance = this;
    }

    @Override
    public Path getConfigDirectory() {
        return this.getDataFolder().toPath();
    }

    public void onLoad() {
        this.flavor = Flavor.create(this.getClass(), new FlavorOptions(this.getLogger(), this.getClass().getPackageName()));
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().reEncodeByDefault(false).checkForUpdates(true).bStats(true).kickOnPacketException(true);
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        ACLogger.info("Enabling AntiCrasher...", new Object[0]);
        PacketEvents.getAPI().init();
        AntiCrasherAPI.setInstance(new BukkitAntiCrasherAPI());
        ACLogger.info("Initialising Metrics.", new Object[0]);
        new Metrics((Plugin)this, 20218);
        this.flavor.startup();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerEvents(), (Plugin)this);
        this.consoleUser = new BukkitUser(UUID.randomUUID(), Bukkit.getConsoleSender());
        ACLogger.info("AntiCrasher enabled with %s checks enabled.".formatted(CheckManager.getInstance().checks.size()), new Object[0]);
    }

    public void onDisable() {
        this.flavor.close();
        PacketEvents.getAPI().terminate();
        ACLogger.info("AntiCrasher has disabled.", new Object[0]);
    }

    @Override
    public boolean isPluginEnabled(String pluginName) {
        return this.getServer().getPluginManager().isPluginEnabled(pluginName);
    }

    @Override
    public Version getCurrentVersion() {
        return Version.fromString(this.getDescription().getVersion());
    }

    @Override
    public void runLater(Runnable runnable, long delay) {
        MultiLib.getGlobalRegionScheduler().runDelayed((Plugin)this, task -> runnable.run(), delay);
    }

    @Override
    public User getConsoleUser() {
        return this.consoleUser;
    }

    @Override
    public String getPlatformType() {
        return "plugin";
    }

    @Generated
    public static AntiCrasher getInstance() {
        return instance;
    }
}

