/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.bukkit.command;

import info.preva1l.trashcan.flavor.annotations.Configure;
import info.preva1l.trashcan.flavor.annotations.Service;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import net.craftsupport.anticrasher.api.AntiCrasherAPI;
import net.craftsupport.anticrasher.api.user.User;
import net.craftsupport.anticrasher.bukkit.AntiCrasher;
import net.craftsupport.anticrasher.bukkit.user.BukkitUser;
import net.craftsupport.anticrasher.common.command.impl.ReloadCommand;
import net.craftsupport.anticrasher.common.util.ACLogger;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.annotations.AnnotationParser;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.meta.SimpleCommandMeta;
import org.incendo.cloud.paper.LegacyPaperCommandManager;

@Service
public class BukkitCommandHandler {
    public static final BukkitCommandHandler instance = new BukkitCommandHandler();
    private LegacyPaperCommandManager<User> manager;
    private AnnotationParser<User> annotationParser;

    @Configure
    public void initialise() {
        SenderMapper senderMapper = SenderMapper.create(commandSender -> {
            if (commandSender instanceof Player) {
                Player player = (Player)commandSender;
                return Objects.requireNonNull(AntiCrasherAPI.getInstance().getUserManager().getOrCreate(player.getUniqueId(), player));
            }
            return new BukkitUser(UUID.randomUUID(), commandSender);
        }, sender -> (CommandSender)sender.getSource());
        this.manager = new LegacyPaperCommandManager((Plugin)AntiCrasher.getInstance(), ExecutionCoordinator.asyncCoordinator(), senderMapper);
        this.annotationParser = new AnnotationParser(this.manager, User.class, params -> SimpleCommandMeta.empty());
        this.registerSubCommands();
        ACLogger.info("Registered commands.", new Object[0]);
    }

    private void registerSubCommands() {
        this.annotationParser.parse(new Object[]{new ReloadCommand()});
    }

    @Generated
    public LegacyPaperCommandManager<User> getManager() {
        return this.manager;
    }

    @Generated
    public AnnotationParser<User> getAnnotationParser() {
        return this.annotationParser;
    }

    @Generated
    public static BukkitCommandHandler getInstance() {
        return instance;
    }
}

