/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.bukkit.user;

import java.util.List;
import java.util.UUID;
import lombok.Generated;
import net.craftsupport.anticrasher.api.AntiCrasherAPI;
import net.craftsupport.anticrasher.api.util.objects.Tuple;
import net.craftsupport.anticrasher.bukkit.util.PlaceholderProcessor;
import net.craftsupport.anticrasher.common.util.TextUtil;
import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.User;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BukkitUser
extends net.craftsupport.anticrasher.api.user.User {
    private final User user;
    private final UUID uuid;
    private final CommandSender source;
    private final boolean bypass;

    public BukkitUser(UUID uuid, Object source) {
        Player player = Bukkit.getPlayer((UUID)uuid);
        this.user = player != null ? PacketEvents.getAPI().getPlayerManager().getUser(player) : null;
        this.uuid = uuid;
        this.source = (CommandSender)source;
        this.bypass = this.source != null && this.source.hasPermission("anticrasher.bypass");
    }

    @Override
    public String getName() {
        return this.source != null ? this.source.getName() : this.getUniqueId().toString();
    }

    @Override
    @SafeVarargs
    public final void sendMessage(String message, Tuple<String, Object> ... args) {
        String parsedMessage = this.processPlaceholders(message);
        this.source.sendMessage(TextUtil.text(parsedMessage, args));
    }

    @Override
    @SafeVarargs
    public final void sendMessage(List<String> messages, Tuple<String, Object> ... args) {
        List<String> parsedMessages = messages.stream().map(this::processPlaceholders).toList();
        this.source.sendMessage(TextUtil.text(parsedMessages, args));
    }

    @Override
    public void sendMessage(Component component) {
        this.source.sendMessage(component);
    }

    @Override
    public boolean hasPermission(String permissionNode) {
        return this.source != null && this.source.hasPermission(permissionNode);
    }

    @Override
    public User toPE() {
        return this.user;
    }

    @Override
    public String processPlaceholders(String message) {
        if (AntiCrasherAPI.getInstance().getPlatform().isPluginEnabled("PlaceholderAPI") && this.source != null) {
            return PlaceholderProcessor.processPlaceholders(message, this.asPlayer());
        }
        return message;
    }

    @Override
    public boolean shouldBypass() {
        return this.bypass;
    }

    @Override
    public UUID getUniqueId() {
        return this.uuid;
    }

    private Player asPlayer() {
        return this.source instanceof Player ? (Player)this.source : null;
    }

    @Generated
    public User getUser() {
        return this.user;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public CommandSender getSource() {
        return this.source;
    }

    @Generated
    public boolean isBypass() {
        return this.bypass;
    }
}

