/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.bukkit.user;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.craftsupport.anticrasher.api.user.User;
import net.craftsupport.anticrasher.api.user.UserManager;
import net.craftsupport.anticrasher.bukkit.user.BukkitUser;
import org.jetbrains.annotations.NotNull;

public class BukkitUserManager
implements UserManager {
    private final Map<UUID, User> userCache = new ConcurrentHashMap<UUID, User>();

    @Override
    public User get(UUID uuid) {
        if (uuid == null) {
            return new BukkitUser(UUID.randomUUID(), null);
        }
        return this.userCache.get(uuid);
    }

    @Override
    @NotNull
    public User getOrCreate(UUID uuid, Object source) {
        return this.userCache.containsKey(uuid) ? this.get(uuid) : this.create(uuid, source);
    }

    @Override
    public User create(UUID uuid, Object source) {
        return this.userCache.computeIfAbsent(uuid, id -> new BukkitUser((UUID)id, source));
    }

    @Override
    public void invalidate(UUID uuid) {
        this.userCache.remove(uuid);
    }

    @Override
    public Collection<User> getOnlineUsers() {
        return this.userCache.values();
    }
}

