/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.common.update;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import info.preva1l.trashcan.Version;
import info.preva1l.trashcan.flavor.annotations.Configure;
import info.preva1l.trashcan.flavor.annotations.Service;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.craftsupport.anticrasher.api.AntiCrasherAPI;
import net.craftsupport.anticrasher.api.user.User;
import net.craftsupport.anticrasher.api.util.objects.Tuple;

@Service
public class UpdateChecker {
    public static final UpdateChecker instance = new UpdateChecker();
    private final Version CURRENT_VERSION = AntiCrasherAPI.getInstance().getPlatform().getCurrentVersion();
    private Version LATEST_VERSION;

    @Configure
    public void check() {
        ((CompletableFuture)CompletableFuture.supplyAsync(this::query).thenAccept(latestVersion -> {
            this.LATEST_VERSION = latestVersion;
            AntiCrasherAPI.getInstance().getPlatform().runLater(() -> this.sendNotification(AntiCrasherAPI.getInstance().getPlatform().getConsoleUser()), 60L);
        })).exceptionally(ex -> {
            throw new RuntimeException((Throwable)ex);
        });
    }

    public void sendNotification(User user) {
        if (this.LATEST_VERSION == null || this.CURRENT_VERSION.compareTo(this.LATEST_VERSION) >= 0) {
            return;
        }
        user.sendMessage("<blue><bold>AntiCrasher<reset> <dark_grey>\u00bb <yellow>New version of AntiCrasher available! <grey>Current: <yellow>%s <grey>Latest: <green>%s.".formatted(this.CURRENT_VERSION, this.LATEST_VERSION), new Tuple[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Version query() {
        String endpoint = "https://api.modrinth.com/v2/project/anticrasher/version";
        String platform = AntiCrasherAPI.getInstance().getPlatform().getPlatformType();
        try (InputStreamReader reader = new InputStreamReader(new URL(endpoint).openConnection().getInputStream());){
            JsonArray versions = JsonParser.parseReader((Reader)reader).getAsJsonArray();
            int i = 0;
            while (i < versions.size()) {
                JsonObject version = versions.get(i).getAsJsonObject();
                if (version.get("version_type").getAsString().equals("release") && version.get("version_number").getAsString().contains(platform)) {
                    Version version2 = Version.fromString(version.get("version_number").getAsString().replaceAll(String.format("^v|\\-%s$", platform), ""));
                    return version2;
                }
                ++i;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to check for updates.", e);
        }
    }

    @Generated
    public static UpdateChecker getInstance() {
        return instance;
    }
}

