/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.protocol.dialog.action;

import net.craftsupport.anticrasher.packetevents.api.protocol.chat.clickevent.ClickEvent;
import net.craftsupport.anticrasher.packetevents.api.protocol.chat.clickevent.ClickEventAction;
import net.craftsupport.anticrasher.packetevents.api.protocol.chat.clickevent.ClickEventActions;
import net.craftsupport.anticrasher.packetevents.api.protocol.dialog.action.Action;
import net.craftsupport.anticrasher.packetevents.api.protocol.dialog.action.ActionType;
import net.craftsupport.anticrasher.packetevents.api.protocol.dialog.action.ActionTypes;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTCompound;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class StaticAction
implements Action {
    private final ActionType<?> actionType;
    private final ClickEvent clickEvent;

    public StaticAction(ClickEvent clickEvent) {
        if (!clickEvent.getAction().isAllowFromServer()) {
            throw new IllegalArgumentException("Can't create action for unreadable click event with action " + clickEvent.getAction());
        }
        this.actionType = (ActionType)ActionTypes.getRegistry().getByNameOrThrow(clickEvent.getAction().getName());
        this.clickEvent = clickEvent;
    }

    public static StaticAction decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        String actionName = compound.getStringTagValueOrThrow("type");
        ClickEventAction action = (ClickEventAction)ClickEventActions.getRegistry().getByNameOrThrow(actionName);
        Object clickEvent = action.decode(compound, wrapper);
        return new StaticAction((ClickEvent)clickEvent);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, StaticAction action) {
        action.clickEvent.getAction().encode(compound, wrapper, action.clickEvent);
    }

    @Override
    public ActionType<?> getType() {
        return this.actionType;
    }

    public ClickEvent getClickEvent() {
        return this.clickEvent;
    }
}

