/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.wrapper.configuration.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.craftsupport.anticrasher.packetevents.api.event.PacketSendEvent;
import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerVersion;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBT;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTCompound;
import net.craftsupport.anticrasher.packetevents.api.protocol.nbt.NBTList;
import net.craftsupport.anticrasher.packetevents.api.protocol.packettype.PacketType;
import net.craftsupport.anticrasher.packetevents.api.resources.ResourceLocation;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WrapperConfigServerRegistryData
extends PacketWrapper<WrapperConfigServerRegistryData> {
    private NBTCompound registryData;
    private ResourceLocation registryKey;
    private List<RegistryElement> elements;

    public WrapperConfigServerRegistryData(PacketSendEvent event) {
        super(event);
    }

    @ApiStatus.Obsolete
    public WrapperConfigServerRegistryData(NBTCompound registryData) {
        this(registryData, null, null);
    }

    public WrapperConfigServerRegistryData(ResourceLocation registryKey, List<RegistryElement> elements) {
        this(null, registryKey, elements);
    }

    @ApiStatus.Obsolete
    public WrapperConfigServerRegistryData(@Nullable NBTCompound registryData, @Nullable ResourceLocation registryKey, @Nullable List<RegistryElement> elements) {
        super(PacketType.Configuration.Server.REGISTRY_DATA);
        this.registryData = registryData;
        this.registryKey = registryKey;
        this.elements = elements;
    }

    @Override
    public void read() {
        if (this.serverVersion.isOlderThan(ServerVersion.V_1_20_5)) {
            this.registryData = this.readUnlimitedNBT();
            return;
        }
        this.registryKey = this.readIdentifier();
        this.elements = this.readList(wrapper -> {
            ResourceLocation id = wrapper.readIdentifier();
            NBT data = (NBT)wrapper.readOptional(PacketWrapper::readNBTRaw);
            return new RegistryElement(id, data);
        });
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThan(ServerVersion.V_1_20_5)) {
            this.writeNBT(this.registryData);
            return;
        }
        this.writeIdentifier(this.registryKey);
        this.writeList(this.elements, (wrapper, element) -> {
            wrapper.writeIdentifier(element.getId());
            wrapper.writeOptional(element.getData(), PacketWrapper::writeNBTRaw);
        });
    }

    @Override
    public void copy(WrapperConfigServerRegistryData wrapper) {
        this.registryData = wrapper.registryData;
        this.registryKey = wrapper.registryKey;
        this.elements = wrapper.elements;
    }

    @ApiStatus.Obsolete
    @Nullable
    public NBTCompound getRegistryData() {
        return this.registryData;
    }

    @ApiStatus.Obsolete
    public void setRegistryData(NBTCompound registryData) {
        this.registryData = registryData;
    }

    @Nullable
    public ResourceLocation getRegistryKey() {
        return this.registryKey;
    }

    public void setRegistryKey(ResourceLocation registryKey) {
        this.registryKey = registryKey;
    }

    @Nullable
    public List<RegistryElement> getElements() {
        return this.elements;
    }

    public void setElements(List<RegistryElement> elements) {
        this.elements = elements;
    }

    public static class RegistryElement {
        private final ResourceLocation id;
        @Nullable
        private final NBT data;

        public RegistryElement(NBTCompound nbt) {
            this(new ResourceLocation(nbt.getStringTagValueOrThrow("name")), nbt.getTagOrNull("element"));
        }

        public RegistryElement(ResourceLocation id, @Nullable NBT data) {
            this.id = id;
            this.data = data;
        }

        public static List<RegistryElement> convertNbt(NBTList<NBTCompound> list) {
            ArrayList<RegistryElement> elements = new ArrayList<RegistryElement>(list.size());
            for (NBTCompound tag : list.getTags()) {
                elements.add(new RegistryElement(tag));
            }
            return Collections.unmodifiableList(elements);
        }

        public ResourceLocation getId() {
            return this.id;
        }

        @Nullable
        public NBT getData() {
            return this.data;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RegistryElement)) {
                return false;
            }
            RegistryElement that = (RegistryElement)obj;
            if (!this.id.equals(that.id)) {
                return false;
            }
            return Objects.equals(this.data, that.data);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "RegistryElement{id=" + this.id + ", data=" + this.data + '}';
        }
    }
}

