/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.api.wrapper.play.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.craftsupport.anticrasher.packetevents.api.event.PacketSendEvent;
import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerVersion;
import net.craftsupport.anticrasher.packetevents.api.protocol.chat.RemoteChatSession;
import net.craftsupport.anticrasher.packetevents.api.protocol.packettype.PacketType;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.GameMode;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.TextureProperty;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.UserProfile;
import net.craftsupport.anticrasher.packetevents.api.wrapper.PacketWrapper;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.Nullable;

public class WrapperPlayServerPlayerInfoUpdate
extends PacketWrapper<WrapperPlayServerPlayerInfoUpdate> {
    private EnumSet<Action> actions;
    private List<PlayerInfo> entries;

    public WrapperPlayServerPlayerInfoUpdate(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerPlayerInfoUpdate(EnumSet<Action> actions, List<PlayerInfo> entries) {
        super(PacketType.Play.Server.PLAYER_INFO_UPDATE);
        this.actions = actions;
        this.entries = entries;
    }

    public WrapperPlayServerPlayerInfoUpdate(EnumSet<Action> actions, PlayerInfo ... entries) {
        super(PacketType.Play.Server.PLAYER_INFO_UPDATE);
        this.actions = actions;
        this.entries = new ArrayList<PlayerInfo>();
        Collections.addAll(this.entries, entries);
    }

    public WrapperPlayServerPlayerInfoUpdate(Action action, List<PlayerInfo> entries) {
        this(EnumSet.of(action), entries);
    }

    public WrapperPlayServerPlayerInfoUpdate(Action action, PlayerInfo ... entries) {
        this(EnumSet.of(action), entries);
    }

    @Override
    public void read() {
        this.actions = this.readEnumSet(Action.class);
        this.entries = this.readList(wrapper -> {
            UUID uuid = wrapper.readUUID();
            UserProfile gameProfile = new UserProfile(uuid, null);
            GameMode gameMode = GameMode.defaultGameMode();
            boolean listed = false;
            int latency = 0;
            RemoteChatSession chatSession = null;
            Component displayName = null;
            int listOrder = 0;
            boolean showHat = false;
            block10: for (Action action : this.actions) {
                switch (action.ordinal()) {
                    case 0: {
                        gameProfile.setUUID(uuid);
                        gameProfile.setName(wrapper.readString(16));
                        int propertyCount = wrapper.readVarInt();
                        for (int j = 0; j < propertyCount; ++j) {
                            String propertyName = wrapper.readString();
                            String propertyValue = wrapper.readString();
                            String propertySignature = (String)wrapper.readOptional(PacketWrapper::readString);
                            TextureProperty textureProperty = new TextureProperty(propertyName, propertyValue, propertySignature);
                            gameProfile.getTextureProperties().add(textureProperty);
                        }
                        continue block10;
                    }
                    case 1: {
                        chatSession = (RemoteChatSession)wrapper.readOptional(PacketWrapper::readRemoteChatSession);
                        break;
                    }
                    case 2: {
                        gameMode = GameMode.getById(wrapper.readVarInt());
                        break;
                    }
                    case 3: {
                        listed = wrapper.readBoolean();
                        break;
                    }
                    case 4: {
                        latency = wrapper.readVarInt();
                        break;
                    }
                    case 5: {
                        displayName = (Component)wrapper.readOptional(PacketWrapper::readComponent);
                        break;
                    }
                    case 6: {
                        if (!this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) break;
                        listOrder = wrapper.readVarInt();
                        break;
                    }
                    case 7: {
                        if (!this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_4)) break;
                        showHat = wrapper.readBoolean();
                    }
                }
            }
            return new PlayerInfo(gameProfile, listed, latency, gameMode, displayName, chatSession, listOrder, showHat);
        });
    }

    @Override
    public void write() {
        this.writeEnumSet(this.actions, Action.class);
        this.writeList(this.entries, (wrapper, playerInfo) -> {
            wrapper.writeUUID(playerInfo.getProfileId());
            for (Action action : this.actions) {
                switch (action.ordinal()) {
                    case 0: {
                        wrapper.writeString(playerInfo.getGameProfile().getName(), 16);
                        this.writeList(playerInfo.getGameProfile().getTextureProperties(), (w, textureProperty) -> {
                            w.writeString(textureProperty.getName());
                            w.writeString(textureProperty.getValue());
                            w.writeOptional(textureProperty.getSignature(), PacketWrapper::writeString);
                        });
                        break;
                    }
                    case 1: {
                        wrapper.writeOptional(playerInfo.getChatSession(), PacketWrapper::writeRemoteChatSession);
                        break;
                    }
                    case 2: {
                        wrapper.writeVarInt(playerInfo.getGameMode().getId());
                        break;
                    }
                    case 3: {
                        wrapper.writeBoolean(playerInfo.isListed());
                        break;
                    }
                    case 4: {
                        wrapper.writeVarInt(playerInfo.getLatency());
                        break;
                    }
                    case 5: {
                        wrapper.writeOptional(playerInfo.getDisplayName(), PacketWrapper::writeComponent);
                        break;
                    }
                    case 6: {
                        if (!this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_2)) break;
                        wrapper.writeVarInt(playerInfo.getListOrder());
                        break;
                    }
                    case 7: {
                        if (!this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_21_4)) break;
                        wrapper.writeBoolean(playerInfo.isShowHat());
                    }
                }
            }
        });
    }

    @Override
    public void copy(WrapperPlayServerPlayerInfoUpdate wrapper) {
        this.actions = wrapper.actions;
        this.entries = wrapper.entries;
    }

    public EnumSet<Action> getActions() {
        return this.actions;
    }

    public void setActions(EnumSet<Action> actions) {
        this.actions = actions;
    }

    public List<PlayerInfo> getEntries() {
        return this.entries;
    }

    public void setEntries(List<PlayerInfo> entries) {
        this.entries = entries;
    }

    public static class PlayerInfo {
        private UserProfile profile;
        private boolean listed = true;
        private int latency;
        private GameMode gameMode;
        @Nullable
        private Component displayName;
        @Nullable
        private RemoteChatSession chatSession;
        private int listOrder;
        private boolean showHat;

        public PlayerInfo(UUID profileId) {
            this(new UserProfile(profileId, ""));
        }

        public PlayerInfo(UserProfile profile) {
            this.profile = profile;
        }

        public PlayerInfo(UserProfile profile, boolean listed, int latency, GameMode gameMode, @Nullable Component displayName, @Nullable RemoteChatSession chatSession) {
            this(profile, listed, latency, gameMode, displayName, chatSession, 0);
        }

        public PlayerInfo(UserProfile profile, boolean listed, int latency, GameMode gameMode, @Nullable Component displayName, @Nullable RemoteChatSession chatSession, int listOrder) {
            this(profile, listed, latency, gameMode, displayName, chatSession, listOrder, false);
        }

        public PlayerInfo(UserProfile profile, boolean listed, int latency, GameMode gameMode, @Nullable Component displayName, @Nullable RemoteChatSession chatSession, int listOrder, boolean showHat) {
            this.profile = profile;
            this.listed = listed;
            this.latency = latency;
            this.gameMode = gameMode;
            this.displayName = displayName;
            this.chatSession = chatSession;
            this.listOrder = listOrder;
            this.showHat = showHat;
        }

        public UUID getProfileId() {
            return this.profile.getUUID();
        }

        public UserProfile getGameProfile() {
            return this.profile;
        }

        public boolean isListed() {
            return this.listed;
        }

        public int getLatency() {
            return this.latency;
        }

        public GameMode getGameMode() {
            return this.gameMode;
        }

        @Nullable
        public Component getDisplayName() {
            return this.displayName;
        }

        @Nullable
        public RemoteChatSession getChatSession() {
            return this.chatSession;
        }

        public int getListOrder() {
            return this.listOrder;
        }

        public boolean isShowHat() {
            return this.showHat;
        }

        public void setGameProfile(UserProfile gameProfile) {
            this.profile = gameProfile;
        }

        public void setListed(boolean listed) {
            this.listed = listed;
        }

        public void setLatency(int latency) {
            this.latency = latency;
        }

        public void setGameMode(GameMode gameMode) {
            this.gameMode = gameMode;
        }

        public void setDisplayName(@Nullable Component displayName) {
            this.displayName = displayName;
        }

        public void setChatSession(@Nullable RemoteChatSession chatSession) {
            this.chatSession = chatSession;
        }

        public void setListOrder(int listOrder) {
            this.listOrder = listOrder;
        }

        public void setShowHat(boolean showHat) {
            this.showHat = showHat;
        }
    }

    public static enum Action {
        ADD_PLAYER,
        INITIALIZE_CHAT,
        UPDATE_GAME_MODE,
        UPDATE_LISTED,
        UPDATE_LATENCY,
        UPDATE_DISPLAY_NAME,
        UPDATE_LIST_ORDER,
        UPDATE_HAT;

        public static final Action[] VALUES;

        static {
            VALUES = Action.values();
        }
    }
}

