/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.impl;

import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.api.event.PacketListenerPriority;
import net.craftsupport.anticrasher.packetevents.api.event.SimplePacketListenerAbstract;
import net.craftsupport.anticrasher.packetevents.api.event.UserConnectEvent;
import net.craftsupport.anticrasher.packetevents.api.event.UserDisconnectEvent;
import net.craftsupport.anticrasher.packetevents.api.event.UserLoginEvent;
import net.craftsupport.anticrasher.packetevents.api.event.simple.PacketConfigReceiveEvent;
import net.craftsupport.anticrasher.packetevents.api.event.simple.PacketConfigSendEvent;
import net.craftsupport.anticrasher.packetevents.api.event.simple.PacketLoginSendEvent;
import net.craftsupport.anticrasher.packetevents.api.event.simple.PacketPlayReceiveEvent;
import net.craftsupport.anticrasher.packetevents.api.event.simple.PacketPlaySendEvent;
import net.craftsupport.anticrasher.packetevents.api.protocol.packettype.PacketType;
import net.craftsupport.anticrasher.packetevents.api.protocol.world.states.type.StateTypes;
import net.craftsupport.anticrasher.packetevents.api.util.TimeStampMode;
import net.craftsupport.anticrasher.packetevents.api.wrapper.play.client.WrapperPlayClientInteractEntity;
import net.craftsupport.anticrasher.packetevents.api.wrapper.play.server.WrapperPlayServerBlockChange;
import net.craftsupport.anticrasher.packetevents.api.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import net.craftsupport.anticrasher.packetevents.impl.factory.spigot.SpigotPacketEventsBuilder;
import net.craftsupport.anticrasher.packetevents.impl.util.SpigotConversionUtil;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PacketEventsPlugin
extends JavaPlugin {
    public void onLoad() {
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PacketEvents.getAPI().getSettings().debug(false).checkForUpdates(true).timeStampMode(TimeStampMode.MILLIS).reEncodeByDefault(true);
        PacketEvents.getAPI().init();
        SimplePacketListenerAbstract listener = new SimplePacketListenerAbstract(PacketListenerPriority.HIGH){

            @Override
            public void onPacketLoginSend(PacketLoginSendEvent event) {
            }

            @Override
            public void onPacketConfigReceive(PacketConfigReceiveEvent event) {
            }

            @Override
            public void onPacketConfigSend(PacketConfigSendEvent event) {
            }

            @Override
            public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
                WrapperPlayClientInteractEntity interaction;
                if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY && (interaction = new WrapperPlayClientInteractEntity(event)).getAction() == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                    Player player = (Player)event.getPlayer();
                    WrapperPlayServerBlockChange blockChange = new WrapperPlayServerBlockChange(SpigotConversionUtil.fromBukkitLocation(player.getLocation()).getPosition().toVector3i().subtract(0, 1, 0), StateTypes.COAL_BLOCK.createBlockState().getGlobalId());
                    event.getUser().sendPacket(blockChange);
                }
            }

            @Override
            public void onPacketPlaySend(PacketPlaySendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.BLOCK_CHANGE) {
                    WrapperPlayServerBlockChange bc = new WrapperPlayServerBlockChange(event);
                    ((Player)event.getPlayer()).sendMessage("Type: " + bc.getBlockState().getType().getName());
                } else if (event.getPacketType() == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
                    WrapperPlayServerSystemChatMessage wrapperPlayServerSystemChatMessage = new WrapperPlayServerSystemChatMessage(event);
                }
            }

            @Override
            public void onUserConnect(UserConnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " connected...");
            }

            @Override
            public void onUserLogin(UserLoginEvent event) {
                PacketEvents.getAPI().getLogManager().debug("You logged in! User name: " + event.getUser().getProfile().getName());
            }

            @Override
            public void onUserDisconnect(UserDisconnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " disconnected...");
            }
        };
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }
}

