/*
 * Decompiled with CFR 0.152.
 */
package net.craftsupport.anticrasher.packetevents.impl.factory.spigot;

import net.craftsupport.anticrasher.packetevents.api.PacketEvents;
import net.craftsupport.anticrasher.packetevents.api.PacketEventsAPI;
import net.craftsupport.anticrasher.packetevents.api.injector.ChannelInjector;
import net.craftsupport.anticrasher.packetevents.api.manager.player.PlayerManager;
import net.craftsupport.anticrasher.packetevents.api.manager.protocol.ProtocolManager;
import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerManager;
import net.craftsupport.anticrasher.packetevents.api.manager.server.ServerVersion;
import net.craftsupport.anticrasher.packetevents.api.netty.NettyManager;
import net.craftsupport.anticrasher.packetevents.api.protocol.packettype.PacketType;
import net.craftsupport.anticrasher.packetevents.api.protocol.player.User;
import net.craftsupport.anticrasher.packetevents.api.protocol.world.states.WrappedBlockState;
import net.craftsupport.anticrasher.packetevents.api.settings.PacketEventsSettings;
import net.craftsupport.anticrasher.packetevents.api.util.LogManager;
import net.craftsupport.anticrasher.packetevents.api.util.PEVersion;
import net.craftsupport.anticrasher.packetevents.impl.bstats.bukkit.Metrics;
import net.craftsupport.anticrasher.packetevents.impl.bstats.charts.SimplePie;
import net.craftsupport.anticrasher.packetevents.impl.bukkit.InternalBukkitListener;
import net.craftsupport.anticrasher.packetevents.impl.bukkit.InternalBukkitLoginListener;
import net.craftsupport.anticrasher.packetevents.impl.bukkit.InternalGlobalBukkitListener;
import net.craftsupport.anticrasher.packetevents.impl.bukkit.InternalPaperJoinListener;
import net.craftsupport.anticrasher.packetevents.impl.bukkit.InternalPaperListener;
import net.craftsupport.anticrasher.packetevents.impl.injector.SpigotChannelInjector;
import net.craftsupport.anticrasher.packetevents.impl.injector.connection.ServerConnectionInitializer;
import net.craftsupport.anticrasher.packetevents.impl.manager.InternalBukkitPacketListener;
import net.craftsupport.anticrasher.packetevents.impl.manager.player.PlayerManagerImpl;
import net.craftsupport.anticrasher.packetevents.impl.manager.protocol.ProtocolManagerImpl;
import net.craftsupport.anticrasher.packetevents.impl.manager.server.ServerManagerImpl;
import net.craftsupport.anticrasher.packetevents.impl.netty.NettyManagerImpl;
import net.craftsupport.anticrasher.packetevents.impl.util.BukkitLogManager;
import net.craftsupport.anticrasher.packetevents.impl.util.SpigotReflectionUtil;
import net.craftsupport.anticrasher.packetevents.impl.util.folia.FoliaScheduler;
import net.craftsupport.anticrasher.packetevents.impl.util.protocolsupport.ProtocolSupportUtil;
import net.craftsupport.anticrasher.packetevents.impl.util.viaversion.CustomPipelineUtil;
import net.craftsupport.anticrasher.packetevents.impl.util.viaversion.ViaVersionUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class SpigotPacketEventsBuilder {
    private static PacketEventsAPI<Plugin> API_INSTANCE;

    public static void clearBuildCache() {
        API_INSTANCE = null;
    }

    public static PacketEventsAPI<Plugin> build(Plugin plugin) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpigotPacketEventsBuilder.buildNoCache(plugin);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<Plugin> build(Plugin plugin, PacketEventsSettings settings) {
        if (API_INSTANCE == null) {
            API_INSTANCE = SpigotPacketEventsBuilder.buildNoCache(plugin, settings);
        }
        return API_INSTANCE;
    }

    public static PacketEventsAPI<Plugin> buildNoCache(Plugin plugin) {
        return SpigotPacketEventsBuilder.buildNoCache(plugin, new PacketEventsSettings());
    }

    public static PacketEventsAPI<Plugin> buildNoCache(final Plugin plugin, final PacketEventsSettings inSettings) {
        return new PacketEventsAPI<Plugin>(){
            private final PacketEventsSettings settings;
            private final ProtocolManager protocolManager;
            private final ServerManager serverManager;
            private final PlayerManager playerManager;
            private final NettyManager nettyManager;
            private final SpigotChannelInjector injector;
            private final LogManager logManager;
            private boolean loaded;
            private boolean initialized;
            private boolean lateBind;
            private boolean terminated;
            {
                this.settings = inSettings;
                this.protocolManager = new ProtocolManagerImpl();
                this.serverManager = new ServerManagerImpl();
                this.playerManager = new PlayerManagerImpl();
                this.nettyManager = new NettyManagerImpl();
                this.injector = new SpigotChannelInjector();
                this.logManager = new BukkitLogManager();
                this.lateBind = false;
                this.terminated = false;
            }

            @Override
            public void load() {
                if (!this.loaded) {
                    String id = plugin.getName().toLowerCase();
                    PacketEvents.IDENTIFIER = "pe-" + id;
                    PacketEvents.ENCODER_NAME = "pe-encoder-" + id;
                    PacketEvents.DECODER_NAME = "pe-decoder-" + id;
                    PacketEvents.CONNECTION_HANDLER_NAME = "pe-connection-handler-" + id;
                    PacketEvents.SERVER_CHANNEL_HANDLER_NAME = "pe-connection-initializer-" + id;
                    PacketEvents.TIMEOUT_HANDLER_NAME = "pe-timeout-handler-" + id;
                    try {
                        SpigotReflectionUtil.init();
                        CustomPipelineUtil.init();
                        WrappedBlockState.ensureLoad();
                    }
                    catch (Exception ex) {
                        throw new IllegalStateException(ex);
                    }
                    if (!PacketType.isPrepared()) {
                        PacketType.prepare();
                    }
                    boolean bl = this.lateBind = !this.injector.isServerBound();
                    if (!this.lateBind) {
                        this.injector.inject();
                    }
                    this.loaded = true;
                    this.getEventManager().registerListener(new InternalBukkitPacketListener());
                }
            }

            @Override
            public boolean isLoaded() {
                return this.loaded;
            }

            @Override
            public void init() {
                this.load();
                if (!this.initialized) {
                    Plugin plugin2 = (Plugin)PacketEvents.getAPI().getPlugin();
                    String bukkitVersion = Bukkit.getBukkitVersion();
                    if (bukkitVersion.contains("Unknown")) {
                        ServerVersion fallbackVersion = ServerVersion.V_1_8_8;
                        String failureToDetectVersionMsg = "Your server software is preventing us from checking the Minecraft Server version. This is what we found: " + bukkitVersion + ". We will assume the Server version is " + fallbackVersion.name() + "...\n If you need assistance, join our Discord server: https://discord.gg/DVHxPPxHZc";
                        plugin2.getLogger().warning(failureToDetectVersionMsg);
                    } else {
                        PEVersion latestSupportedVersion;
                        PEVersion bukkitServerVersion = PEVersion.fromString(bukkitVersion.substring(0, bukkitVersion.indexOf("-")));
                        if (bukkitServerVersion.isNewerThan(latestSupportedVersion = PEVersion.fromString(ServerVersion.getLatest().getReleaseName()))) {
                            plugin2.getLogger().warning("Your build of PacketEvents does not support the Minecraft version " + bukkitServerVersion + "! The latest Minecraft version supported by your build of PacketEvents is " + latestSupportedVersion + ". Please test the development builds, as they may already have support for your Minecraft version (hint: select the build that contains 'spigot'): https://ci.codemc.io/job/retrooper/job/packetevents/ If you're in need of any help, join our Discord server: https://discord.gg/DVHxPPxHZc");
                            Bukkit.getPluginManager().disablePlugin(plugin2);
                            return;
                        }
                    }
                    if (this.settings.shouldCheckForUpdates()) {
                        this.getUpdateChecker().handleUpdateCheck();
                    }
                    Metrics metrics = new Metrics(plugin2, 11327);
                    metrics.addCustomChart(new SimplePie("packetevents_version", () -> this.getVersion().toStringWithoutSnapshot()));
                    Bukkit.getPluginManager().registerEvents((Listener)new InternalGlobalBukkitListener(), plugin2);
                    try {
                        Class.forName("io.papermc.paper.connection.PlayerConnection");
                        if (this.serverManager.getVersion().isNewerThanOrEquals(ServerVersion.V_1_21_9)) {
                            Bukkit.getPluginManager().registerEvents((Listener)new InternalPaperJoinListener(plugin2), plugin2);
                        } else {
                            Bukkit.getPluginManager().registerEvents((Listener)new InternalPaperListener(plugin2), plugin2);
                        }
                    }
                    catch (ClassNotFoundException ignored) {
                        if (this.serverManager.getVersion().isNewerThanOrEquals(ServerVersion.V_1_20_5)) {
                            Bukkit.getPluginManager().registerEvents((Listener)new InternalBukkitLoginListener(), plugin2);
                        }
                        Bukkit.getPluginManager().registerEvents((Listener)new InternalBukkitListener(plugin2), plugin2);
                    }
                    if (this.lateBind) {
                        Runnable lateBindTask = () -> {
                            if (this.injector.isServerBound()) {
                                this.injector.inject();
                            }
                        };
                        FoliaScheduler.runTaskOnInit(plugin2, lateBindTask);
                    }
                    if (!"true".equalsIgnoreCase(System.getenv("PE_IGNORE_INCOMPATIBILITY"))) {
                        this.checkCompatibility();
                    }
                    for (Player player : Bukkit.getOnlinePlayers()) {
                        User user = PacketEvents.getAPI().getPlayerManager().getUser(player);
                        SpigotChannelInjector injector = (SpigotChannelInjector)PacketEvents.getAPI().getInjector();
                        injector.updatePlayer(user, player);
                    }
                    this.initialized = true;
                }
            }

            private void checkCompatibility() {
                int majorVersion;
                Plugin protocolLibPlugin;
                ViaVersionUtil.checkIfViaIsPresent();
                ProtocolSupportUtil.checkIfProtocolSupportIsPresent();
                Plugin viaPlugin = Bukkit.getPluginManager().getPlugin("ViaVersion");
                if (viaPlugin != null) {
                    String[] ver = viaPlugin.getDescription().getVersion().split("\\.", 3);
                    int major = Integer.parseInt(ver[0]);
                    int minor = Integer.parseInt(ver[1]);
                    if (major < 4 || major == 4 && minor < 5) {
                        PacketEvents.getAPI().getLogManager().severe("You are attempting to combine 2.0 PacketEvents with a ViaVersion older than 4.5.0, please update your ViaVersion!");
                        Plugin ourPlugin = this.getPlugin();
                        Bukkit.getPluginManager().disablePlugin(ourPlugin);
                        throw new IllegalStateException("ViaVersion incompatibility! Update to v4.5.0 or newer!");
                    }
                }
                if ((protocolLibPlugin = Bukkit.getPluginManager().getPlugin("ProtocolLib")) != null && (majorVersion = Integer.parseInt(protocolLibPlugin.getDescription().getVersion().split("\\.", 2)[0])) < 5) {
                    PacketEvents.getAPI().getLogManager().severe("You are attempting to combine 2.0 PacketEvents with a ProtocolLib version older than v5.0.0. This is no longer works, please update to their dev builds. https://ci.dmulloy2.net/job/ProtocolLib/lastBuild/");
                    Plugin ourPlugin = this.getPlugin();
                    Bukkit.getPluginManager().disablePlugin(ourPlugin);
                    throw new IllegalStateException("ProtocolLib incompatibility! Update to v5.0.0 or newer!");
                }
            }

            @Override
            public boolean isInitialized() {
                return this.initialized;
            }

            @Override
            public void terminate() {
                if (this.initialized) {
                    this.injector.uninject();
                    for (User user : this.protocolManager.getUsers()) {
                        ServerConnectionInitializer.destroyHandlers(user.getChannel());
                    }
                    this.getEventManager().unregisterAllListeners();
                    this.initialized = false;
                    this.terminated = true;
                }
            }

            @Override
            public boolean isTerminated() {
                return this.terminated;
            }

            @Override
            public Plugin getPlugin() {
                return plugin;
            }

            @Override
            public ProtocolManager getProtocolManager() {
                return this.protocolManager;
            }

            @Override
            public ServerManager getServerManager() {
                return this.serverManager;
            }

            @Override
            public PlayerManager getPlayerManager() {
                return this.playerManager;
            }

            @Override
            public PacketEventsSettings getSettings() {
                return this.settings;
            }

            @Override
            public NettyManager getNettyManager() {
                return this.nettyManager;
            }

            @Override
            public ChannelInjector getInjector() {
                return this.injector;
            }

            @Override
            public LogManager getLogManager() {
                return this.logManager;
            }
        };
    }
}

