/*
 * Decompiled with CFR 0.152.
 */
package fr.adrien1106.reframed.block;

import fr.adrien1106.reframed.block.WaterloggableReFramedBlock;
import fr.adrien1106.reframed.util.VoxelHelper;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_2415;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_2544;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4778;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class ReFramedWallBlock
extends WaterloggableReFramedBlock {
    public static final class_265[] WALL_VOXELS;

    public ReFramedWallBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_22174, (Comparable)class_4778.field_22178)).method_11657((class_2769)class_2741.field_22175, (Comparable)class_4778.field_22178)).method_11657((class_2769)class_2741.field_22177, (Comparable)class_4778.field_22178)).method_11657((class_2769)class_2741.field_22176, (Comparable)class_4778.field_22178));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515((class_2689.class_2690<class_2248, class_2680>)builder.method_11667(new class_2769[]{class_2741.field_12519, class_2741.field_22174, class_2741.field_22175, class_2741.field_22176, class_2741.field_22177}));
    }

    @Override
    public class_2680 method_9559(class_2680 state, class_2350 dir, class_2680 other_state, class_1936 world, class_2338 pos, class_2338 moved) {
        class_2680 new_state = super.method_9559(state, dir, other_state, world, pos, moved);
        if (dir == class_2350.field_11033) {
            return new_state;
        }
        class_2680 top_state = dir == class_2350.field_11036 ? other_state : world.method_8320(pos.method_10084());
        boolean fs = top_state.method_26206((class_1922)world, pos.method_10084(), class_2350.field_11033);
        class_265 top_shape = fs ? null : top_state.method_26220((class_1922)world, pos.method_10084()).method_20538(class_2350.field_11033);
        Map<class_2350, class_2680> neighbors = class_2350.class_2353.field_11062.method_29716().collect(Collectors.toMap(d -> d, d -> {
            if (d == dir) {
                return other_state;
            }
            return world.method_8320(pos.method_10093(d));
        }));
        new_state = ReFramedWallBlock.getWallState(new_state, top_state, neighbors, top_shape, fs, (class_4538)world, pos);
        return (class_2680)new_state.method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(ReFramedWallBlock.shouldHavePost(new_state, top_state, top_shape)));
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_2338 pos;
        class_2680 state = super.method_9605(ctx);
        class_1937 world = ctx.method_8045();
        class_2680 top_state = world.method_8320((pos = ctx.method_8037()).method_10084());
        boolean fs = top_state.method_26206((class_1922)world, pos.method_10084(), class_2350.field_11033);
        class_265 top_shape = fs ? null : top_state.method_26220((class_1922)world, pos.method_10084()).method_20538(class_2350.field_11033);
        Map<class_2350, class_2680> neighbors = class_2350.class_2353.field_11062.method_29716().collect(Collectors.toMap(d -> d, d -> world.method_8320(pos.method_10093(d))));
        state = ReFramedWallBlock.getWallState(state, top_state, neighbors, top_shape, fs, (class_4538)world, pos);
        return (class_2680)state.method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(ReFramedWallBlock.shouldHavePost(state, top_state, top_shape)));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 shape = (Boolean)state.method_11654((class_2769)class_2741.field_12519) != false ? WALL_VOXELS[0] : class_259.method_1073();
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_4778 wall_shape = (class_4778)state.method_11654(ReFramedWallBlock.getWallShape(dir));
            if (wall_shape == class_4778.field_22178) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)WALL_VOXELS[1 + (wall_shape.ordinal() - 1) * 4 + (dir.ordinal() - 2)]);
        }
        return shape;
    }

    @Override
    public class_265 method_9549(class_2680 state, class_1922 view, class_2338 pos, class_3726 ctx) {
        if (this.isGhost(view, pos)) {
            return class_259.method_1073();
        }
        class_265 shape = (Boolean)state.method_11654((class_2769)class_2741.field_12519) != false ? WALL_VOXELS[9] : class_259.method_1073();
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            if (state.method_11654(ReFramedWallBlock.getWallShape(dir)) == class_4778.field_22178) continue;
            shape = class_259.method_1084((class_265)shape, (class_265)WALL_VOXELS[8 + dir.ordinal()]);
        }
        return shape;
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return class_2350.class_2353.field_11062.method_29716().reduce(state, (s, dir) -> (class_2680)s.method_11657(ReFramedWallBlock.getWallShape(rotation.method_10503(dir)), (Comparable)((class_4778)state.method_11654(ReFramedWallBlock.getWallShape(dir)))), (prev, next) -> next);
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return class_2350.class_2353.field_11062.method_29716().reduce(state, (s, dir) -> (class_2680)s.method_11657(ReFramedWallBlock.getWallShape(mirror.method_10343(dir)), (Comparable)((class_4778)state.method_11654(ReFramedWallBlock.getWallShape(dir)))), (prev, next) -> next);
    }

    public static class_2680 getWallState(class_2680 state, class_2680 top_state, Map<class_2350, class_2680> neighbors, class_265 top_shape, boolean fs, class_4538 world, class_2338 pos) {
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2338 offset = pos.method_10093(dir);
            class_2680 neighbor = neighbors.get(dir);
            boolean side_full = neighbor.method_26206((class_1922)world, offset, dir.method_10153());
            class_2769<class_4778> wall_shape = ReFramedWallBlock.getWallShape(dir);
            if (ReFramedWallBlock.shouldConnectTo(neighbor, side_full, dir.method_10153())) {
                state = (class_2680)state.method_11657(wall_shape, (Comparable)(fs || top_state.method_28498(wall_shape) && top_state.method_11654(wall_shape) != class_4778.field_22178 || ReFramedWallBlock.shouldUseTall(WALL_VOXELS[dir.ordinal() + 3], top_shape) ? class_4778.field_22180 : class_4778.field_22179));
                continue;
            }
            state = (class_2680)state.method_11657(wall_shape, (Comparable)class_4778.field_22178);
        }
        return state;
    }

    public static boolean shouldHavePost(class_2680 state, class_2680 top_state, class_265 top_shape) {
        if (top_state.method_28498((class_2769)class_2741.field_12519) && ((Boolean)top_state.method_11654((class_2769)class_2741.field_12519)).booleanValue() || !top_state.method_28498((class_2769)class_2741.field_12519) && top_state.method_28498((class_2769)class_2741.field_22175)) {
            return true;
        }
        if (Stream.of(class_2350.field_11035, class_2350.field_11034).anyMatch(dir -> state.method_11654(ReFramedWallBlock.getWallShape(dir)) != state.method_11654(ReFramedWallBlock.getWallShape(dir.method_10153())))) {
            return true;
        }
        if (class_2350.class_2353.field_11062.method_29716().allMatch(dir -> state.method_11654(ReFramedWallBlock.getWallShape(dir)) == class_4778.field_22178)) {
            return true;
        }
        if (Stream.of(class_2350.field_11035, class_2350.field_11034).anyMatch(dir -> state.method_11654(ReFramedWallBlock.getWallShape(dir)) == state.method_11654(ReFramedWallBlock.getWallShape(dir.method_10153())))) {
            return false;
        }
        return top_state.method_26164(class_3481.field_22276) || top_shape == null || ReFramedWallBlock.shouldUseTall(WALL_VOXELS[0], top_shape);
    }

    public static boolean shouldConnectTo(class_2680 state, boolean side_full, class_2350 side) {
        class_2248 block = state.method_26204();
        boolean bl = block instanceof class_2349 && class_2349.method_16703((class_2680)state, (class_2350)side);
        return state.method_26164(class_3481.field_15504) || !class_2544.method_9581((class_2680)state) && side_full || block instanceof class_2389 || bl;
    }

    public static boolean shouldUseTall(class_265 self_shape, class_265 other_shape) {
        return !class_259.method_1074((class_265)self_shape, (class_265)other_shape, (class_247)class_247.field_16886);
    }

    public static class_2769<class_4778> getWallShape(class_2350 dir) {
        return switch (dir) {
            case class_2350.field_11034 -> class_2741.field_22174;
            case class_2350.field_11043 -> class_2741.field_22175;
            case class_2350.field_11039 -> class_2741.field_22177;
            case class_2350.field_11035 -> class_2741.field_22176;
            default -> null;
        };
    }

    static {
        class_265 POST = ReFramedWallBlock.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        class_265 POST_COLLISION = ReFramedWallBlock.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)24.0, (double)12.0);
        class_265 LOW = ReFramedWallBlock.method_9541((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)14.0, (double)8.0);
        class_265 TALL = ReFramedWallBlock.method_9541((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)8.0);
        class_265 SIDE_COLLISION = ReFramedWallBlock.method_9541((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)24.0, (double)8.0);
        WALL_VOXELS = VoxelHelper.VoxelListBuilder.create(POST, 14).add(LOW, new Function[0]).add(VoxelHelper::mirrorZ).add(VoxelHelper::rotateY).add(VoxelHelper::mirrorX).add(TALL, new Function[0]).add(VoxelHelper::mirrorZ).add(VoxelHelper::rotateY).add(VoxelHelper::mirrorX).add(POST_COLLISION, new Function[0]).add(SIDE_COLLISION, new Function[0]).add(VoxelHelper::mirrorZ).add(VoxelHelper::rotateY).add(VoxelHelper::mirrorX).build();
    }
}

