/*
 * Decompiled with CFR 0.152.
 */
package fr.adrien1106.reframed.client.model.apperance;

import fr.adrien1106.reframed.client.model.QuadPosBounds;
import fr.adrien1106.reframed.client.model.apperance.SpriteProperties;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public abstract class CamoAppearance {
    protected final int id;
    protected final RenderMaterial ao_material;
    protected final RenderMaterial material;

    protected CamoAppearance(RenderMaterial ao_material, RenderMaterial material, int id) {
        this.id = id;
        this.ao_material = ao_material;
        this.material = material;
    }

    @NotNull
    public abstract List<SpriteProperties> getSprites(class_2350 var1, int var2);

    public abstract boolean hasColor(class_2350 var1, int var2, int var3);

    public abstract boolean getAO(int var1);

    @NotNull
    public RenderMaterial getRenderMaterial(boolean ao) {
        return ao && this.ao_material != null ? this.ao_material : this.material;
    }

    public int transformQuad(QuadEmitter quad, int i, int quad_index, int model_id, boolean uv_lock) {
        if (quad.tag() == 0) {
            return 0;
        }
        class_2350 direction = quad.nominalFace();
        List<SpriteProperties> sprites = this.getSprites(direction, model_id);
        if (i == -1) {
            i = sprites.size();
        }
        SpriteProperties properties = sprites.get(sprites.size() - i);
        int tag = i + (quad_index << 8);
        --i;
        QuadPosBounds bounds = properties.bounds();
        if (bounds == null) {
            quad.material(this.getRenderMaterial(this.getAO(model_id)));
            quad.spriteBake(properties.sprite(), 0x20 | properties.flags() | (uv_lock ? 4 : 0));
            quad.tag(tag);
            quad.emit();
            return i;
        }
        QuadPosBounds origin_bounds = QuadPosBounds.read((QuadView)quad, false);
        if (!bounds.matches(origin_bounds)) {
            return i;
        }
        quad.material(this.getRenderMaterial(this.getAO(model_id)));
        bounds.intersection(origin_bounds, direction.method_10166()).apply((MutableQuadView)quad, origin_bounds);
        quad.spriteBake(properties.sprite(), 36);
        quad.tag(tag);
        quad.emit();
        return i;
    }

    public int hashCode() {
        return this.id;
    }
}

