/*
 * Decompiled with CFR 0.152.
 */
package fr.adrien1106.reframed.client.model.apperance;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.adrien1106.reframed.client.ReFramedClient;
import fr.adrien1106.reframed.client.model.DynamicBakedModel;
import fr.adrien1106.reframed.client.model.QuadPosBounds;
import fr.adrien1106.reframed.client.model.apperance.Appearance;
import fr.adrien1106.reframed.client.model.apperance.CamoAppearance;
import fr.adrien1106.reframed.client.model.apperance.ComputedAppearance;
import fr.adrien1106.reframed.client.model.apperance.SingleSpriteAppearance;
import fr.adrien1106.reframed.client.model.apperance.SpriteProperties;
import fr.adrien1106.reframed.client.model.apperance.WeightedComputedAppearance;
import fr.adrien1106.reframed.compat.RebakedModel;
import fr.adrien1106.reframed.mixin.model.WeightedBakedModelAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_4730;
import net.minecraft.class_5819;
import net.minecraft.class_6008;

@Environment(value=EnvType.CLIENT)
public class CamoAppearanceManager {
    protected static final class_4730 DEFAULT_SPRITE_MAIN = new class_4730(class_1723.field_21668, class_2960.method_60655((String)"reframed", (String)"block/framed_block"));
    protected static final class_4730 DEFAULT_SPRITE_SECONDARY = new class_4730(class_1723.field_21668, class_2960.method_60655((String)"reframed", (String)"block/framed_accent_block"));
    private static final class_4730 BARRIER_SPRITE_ID = new class_4730(class_1723.field_21668, class_2960.method_60655((String)"minecraft", (String)"item/barrier"));
    private static final Cache<class_2680, CamoAppearance> APPEARANCE_CACHE = CacheBuilder.newBuilder().maximumSize(2048L).build();
    private final CamoAppearance default_appearance;
    private final CamoAppearance accent_appearance;
    private final CamoAppearance barrier_appearance;
    private final AtomicInteger serial_number = new AtomicInteger(0);
    private final EnumMap<BlendMode, RenderMaterial> ao_materials = new EnumMap(BlendMode.class);
    private final EnumMap<BlendMode, RenderMaterial> materials = new EnumMap(BlendMode.class);

    public CamoAppearanceManager(Function<class_4730, class_1058> spriteLookup) {
        MaterialFinder finder = ReFramedClient.HELPER.getFabricRenderer().materialFinder();
        for (BlendMode blend : BlendMode.values()) {
            finder.clear().disableDiffuse(false).blendMode(blend);
            this.materials.put(blend, finder.ambientOcclusion(TriState.FALSE).find());
            this.ao_materials.put(blend, finder.ambientOcclusion(TriState.DEFAULT).find());
        }
        class_1058 sprite = spriteLookup.apply(DEFAULT_SPRITE_MAIN);
        if (sprite == null) {
            throw new IllegalStateException("Couldn't locate " + String.valueOf(DEFAULT_SPRITE_MAIN) + " !");
        }
        this.default_appearance = new SingleSpriteAppearance(sprite, this.materials.get(BlendMode.CUTOUT), this.serial_number.getAndIncrement());
        sprite = spriteLookup.apply(DEFAULT_SPRITE_SECONDARY);
        if (sprite == null) {
            throw new IllegalStateException("Couldn't locate " + String.valueOf(DEFAULT_SPRITE_MAIN) + " !");
        }
        this.accent_appearance = new SingleSpriteAppearance(sprite, this.materials.get(BlendMode.CUTOUT), this.serial_number.getAndIncrement());
        sprite = spriteLookup.apply(BARRIER_SPRITE_ID);
        this.barrier_appearance = new SingleSpriteAppearance(sprite, this.materials.get(BlendMode.CUTOUT), this.serial_number.getAndIncrement());
    }

    public static void dumpCahe() {
        APPEARANCE_CACHE.invalidateAll();
    }

    public CamoAppearance getDefaultAppearance(int appearance) {
        return appearance == 2 ? this.accent_appearance : this.default_appearance;
    }

    public CamoAppearance getCamoAppearance(class_1920 world, class_2680 state, class_2338 pos, int theme_index, boolean item) {
        class_1087 model = class_310.method_1551().method_1541().method_3349(state);
        if (model instanceof DynamicBakedModel) {
            DynamicBakedModel dynamic_model = (DynamicBakedModel)model;
            if (item && APPEARANCE_CACHE.asMap().containsKey(state)) {
                return (CamoAppearance)APPEARANCE_CACHE.getIfPresent((Object)state);
            }
            model = dynamic_model.computeQuads(world, state, pos, theme_index);
            if (model instanceof RebakedModel) {
                CamoAppearance appearance = this.computeAppearance(model, state, !item);
                if (item) {
                    APPEARANCE_CACHE.put((Object)state, (Object)appearance);
                }
                return appearance;
            }
        }
        if (APPEARANCE_CACHE.asMap().containsKey(state)) {
            return (CamoAppearance)APPEARANCE_CACHE.getIfPresent((Object)state);
        }
        CamoAppearance appearance = this.computeAppearance(model, state, false);
        APPEARANCE_CACHE.put((Object)state, (Object)appearance);
        return appearance;
    }

    public RenderMaterial getCachedMaterial(class_2680 state, boolean ao) {
        EnumMap<BlendMode, RenderMaterial> m = ao ? this.ao_materials : this.materials;
        return (RenderMaterial)m.get(BlendMode.fromRenderLayer((class_1921)class_4696.method_23679((class_2680)state)));
    }

    private CamoAppearance computeAppearance(class_1087 model, class_2680 state, boolean is_dynamic) {
        if (state.method_26204() == class_2246.field_10499) {
            return this.barrier_appearance;
        }
        if (!(model instanceof WeightedBakedModelAccessor)) {
            return new ComputedAppearance(this.getAppearance(model), this.getCachedMaterial(state, true), this.getCachedMaterial(state, false), is_dynamic ? -1 : this.serial_number.getAndIncrement());
        }
        WeightedBakedModelAccessor weighted_model = (WeightedBakedModelAccessor)model;
        List<class_6008.class_6010<Appearance>> appearances = weighted_model.getModels().stream().map(baked_model -> class_6008.method_34980((Object)this.getAppearance((class_1087)baked_model.comp_2542()), (int)baked_model.method_34979().method_34976())).toList();
        return new WeightedComputedAppearance(appearances, this.getCachedMaterial(state, true), this.getCachedMaterial(state, false), is_dynamic ? -1 : this.serial_number.getAndIncrement());
    }

    private Appearance getAppearance(class_1087 model) {
        Renderer r = ReFramedClient.HELPER.getFabricRenderer();
        QuadEmitter quad_emitter = r.meshBuilder().getEmitter();
        RenderMaterial material = r.materialFinder().clear().find();
        class_5819 random = class_5819.method_43047();
        EnumMap<class_2350, List<SpriteProperties>> sprites = new EnumMap<class_2350, List<SpriteProperties>>(class_2350.class);
        Arrays.stream(class_2350.values()).forEach(direction -> {
            List quads = model.method_4707(null, direction, random);
            if (quads.isEmpty()) {
                sprites.put((class_2350)direction, this.default_appearance.getSprites((class_2350)direction, 0));
                return;
            }
            sprites.put((class_2350)direction, new ArrayList());
            quads.forEach(quad -> {
                class_1058 sprite = quad.method_35788();
                if (sprite == null) {
                    return;
                }
                sprites.computeIfPresent((class_2350)direction, (dir, pairs) -> {
                    quad_emitter.fromVanilla(quad, material, direction);
                    pairs.add(new SpriteProperties(sprite, CamoAppearanceManager.getBakeFlags(quad_emitter, sprite), QuadPosBounds.read((QuadView)quad_emitter), quad.method_3360()));
                    return pairs;
                });
            });
        });
        return new Appearance(sprites, model.method_4708());
    }

    private static int getBakeFlags(QuadEmitter emitter, class_1058 sprite) {
        int rotation_v;
        int rotation_u;
        boolean[][] order_matrix = CamoAppearanceManager.getOrderMatrix(emitter, sprite);
        int flag = 0;
        flag = !CamoAppearanceManager.isClockwise(order_matrix) ? ((rotation_u = CamoAppearanceManager.getRotation(CamoAppearanceManager.flipOrderMatrix(order_matrix, 8))) < (rotation_v = CamoAppearanceManager.getRotation(CamoAppearanceManager.flipOrderMatrix(order_matrix, 16))) ? 8 | rotation_u : 0x10 | rotation_v) : (flag |= CamoAppearanceManager.getRotation(order_matrix));
        return flag;
    }

    private static int getRotation(boolean[][] order_matrix) {
        int rotations = 0;
        rotations |= order_matrix[0][0] && !order_matrix[0][1] ? 1 : 0;
        rotations |= !order_matrix[0][0] && !order_matrix[0][1] ? 2 : 0;
        return rotations |= !order_matrix[0][0] && order_matrix[0][1] ? 3 : 0;
    }

    private static boolean isClockwise(boolean[][] rotation_matrix) {
        for (int i = 1; i < rotation_matrix.length; ++i) {
            if (rotation_matrix[i][0] == rotation_matrix[i - 1][1] || rotation_matrix[i][0] == rotation_matrix[i][1]) continue;
            return false;
        }
        return true;
    }

    private static boolean[][] flipOrderMatrix(boolean[][] order_matrix, int flag) {
        boolean[][] new_matrix = new boolean[4][2];
        for (int i = 0; i < 4; ++i) {
            new_matrix[i][0] = flag == 8 != order_matrix[i][0];
            new_matrix[i][1] = flag == 16 != order_matrix[i][1];
        }
        return new_matrix;
    }

    private static boolean[][] getOrderMatrix(QuadEmitter emitter, class_1058 sprite) {
        float u_center = (sprite.method_4594() + sprite.method_4577()) / 2.0f;
        float v_center = (sprite.method_4593() + sprite.method_4575()) / 2.0f;
        boolean[][] order_matrix = new boolean[4][2];
        for (int i = 0; i < 4; ++i) {
            order_matrix[i][0] = emitter.u(i) < u_center;
            order_matrix[i][1] = emitter.v(i) < v_center;
        }
        return order_matrix;
    }
}

