/*
 * Decompiled with CFR 0.152.
 */
package fr.adrien1106.reframed.util.blocks;

import fr.adrien1106.reframed.block.ReFramedEntity;
import fr.adrien1106.reframed.block.ReFramedStairBlock;
import fr.adrien1106.reframed.block.ReFramedStairsCubeBlock;
import fr.adrien1106.reframed.util.blocks.BlockProperties;
import fr.adrien1106.reframed.util.blocks.Corner;
import fr.adrien1106.reframed.util.blocks.Edge;
import fr.adrien1106.reframed.util.blocks.StairShape;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3545;
import net.minecraft.class_3965;

public class BlockHelper {
    public static Corner getPlacementCorner(class_1750 ctx) {
        class_2350 side = ctx.method_8038().method_10153();
        class_243 pos = BlockHelper.getHitPos(ctx.method_17698(), ctx.method_8037());
        class_3545<class_2350, class_2350> sides = BlockHelper.getHitSides(pos, side);
        return Corner.getByDirections(side, (class_2350)sides.method_15442(), (class_2350)sides.method_15441());
    }

    private static class_3545<class_2350, class_2350> getHitSides(class_243 pos, class_2350 side) {
        Iterator axes = Stream.of(class_2350.class_2351.values()).filter(axis -> !axis.equals((Object)side.method_10166())).iterator();
        return new class_3545((Object)BlockHelper.getHitDirection((class_2350.class_2351)axes.next(), pos), (Object)BlockHelper.getHitDirection((class_2350.class_2351)axes.next(), pos));
    }

    public static Edge getPlacementEdge(class_1750 ctx) {
        class_2350 side = ctx.method_8038().method_10153();
        class_243 pos = BlockHelper.getHitPos(ctx.method_17698(), ctx.method_8037());
        class_2350.class_2351 axis = BlockHelper.getHitAxis(pos, side);
        class_2350 part_direction = BlockHelper.getHitDirection(axis, pos);
        return Edge.getByDirections(side, part_direction);
    }

    public static class_2350.class_2351 getHitAxis(class_243 pos, class_2350 side) {
        Stream<class_2350.class_2351> axes = Stream.of(class_2350.class_2351.values()).filter(axis -> !axis.equals((Object)side.method_10166()));
        return axes.reduce((axis_1, axis_2) -> Math.abs(axis_1.method_10172(pos.field_1352, pos.field_1351, pos.field_1350)) > Math.abs(axis_2.method_10172(pos.field_1352, pos.field_1351, pos.field_1350)) ? axis_1 : axis_2).orElse(null);
    }

    public static class_2350 getHitDirection(class_2350.class_2351 axis, class_243 pos) {
        return class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)(axis.method_10172(pos.field_1352, pos.field_1351, pos.field_1350) > 0.0 ? class_2350.class_2352.field_11056 : class_2350.class_2352.field_11060));
    }

    public static class_243 getRelativePos(class_243 pos, class_2338 block_pos) {
        return new class_243(pos.method_10216() - (double)block_pos.method_10263(), pos.method_10214() - (double)block_pos.method_10264(), pos.method_10215() - (double)block_pos.method_10260());
    }

    public static class_243 getHitPos(class_243 pos, class_2338 block_pos) {
        pos = BlockHelper.getRelativePos(pos, block_pos);
        return new class_243(pos.method_10216() - 0.5, pos.method_10214() - 0.5, pos.method_10215() - 0.5);
    }

    public static StairShape getStairsShape(Edge face, class_1922 world, class_2338 pos) {
        String sol;
        StairShape shape = StairShape.STRAIGHT;
        switch (sol = BlockHelper.getNeighborPos(face, face.getFirstDirection(), true, face.getSecondDirection(), world, pos)) {
            case "right": {
                return StairShape.INNER_RIGHT;
            }
            case "left": {
                return StairShape.INNER_LEFT;
            }
        }
        switch (sol = BlockHelper.getNeighborPos(face, face.getSecondDirection(), true, face.getFirstDirection(), world, pos)) {
            case "right": {
                return StairShape.INNER_RIGHT;
            }
            case "left": {
                return StairShape.INNER_LEFT;
            }
        }
        switch (sol = BlockHelper.getNeighborPos(face, face.getFirstDirection(), false, face.getSecondDirection(), world, pos)) {
            case "right": {
                shape = StairShape.FIRST_OUTER_RIGHT;
                break;
            }
            case "left": {
                shape = StairShape.FIRST_OUTER_LEFT;
            }
        }
        switch (sol = BlockHelper.getNeighborPos(face, face.getSecondDirection(), false, face.getFirstDirection(), world, pos)) {
            case "right": {
                if (shape.equals((Object)StairShape.STRAIGHT)) {
                    shape = StairShape.SECOND_OUTER_RIGHT;
                    break;
                }
                if (!shape.equals((Object)StairShape.FIRST_OUTER_RIGHT)) break;
                shape = StairShape.OUTER_RIGHT;
                break;
            }
            case "left": {
                if (shape.equals((Object)StairShape.STRAIGHT)) {
                    shape = StairShape.SECOND_OUTER_LEFT;
                    break;
                }
                if (!shape.equals((Object)StairShape.FIRST_OUTER_LEFT)) break;
                shape = StairShape.OUTER_LEFT;
            }
        }
        return shape;
    }

    public static String getNeighborPos(Edge edge, class_2350 direction, Boolean reverse, class_2350 reference, class_1922 world, class_2338 pos) {
        class_2680 block_state = world.method_8320(pos.method_10093(reverse != false ? direction.method_10153() : direction));
        if (BlockHelper.isStair(block_state) && ((Edge)((Object)block_state.method_11654(BlockProperties.EDGE))).hasDirection(reference)) {
            if (((Edge)((Object)block_state.method_11654(BlockProperties.EDGE))).hasDirection(edge.getLeftDirection())) {
                return "left";
            }
            if (((Edge)((Object)block_state.method_11654(BlockProperties.EDGE))).hasDirection(edge.getRightDirection())) {
                return "right";
            }
        }
        return "";
    }

    public static boolean isStair(class_2680 state) {
        return state.method_26204() instanceof ReFramedStairBlock || state.method_26204() instanceof ReFramedStairsCubeBlock;
    }

    public static class_1269 useCamo(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit, int theme_index) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof ReFramedEntity)) {
            return class_1269.field_5811;
        }
        ReFramedEntity block_entity = (ReFramedEntity)class_25862;
        class_1799 held = player.method_5998(hand);
        class_1792 class_17922 = held.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1750 ctx;
            class_2248 block;
            class_2680 placement_state;
            class_1747 block_item = (class_1747)class_17922;
            if (block_entity.getTheme(theme_index).method_26204() == class_2246.field_10124 && (placement_state = (block = block_item.method_7711()).method_9605(ctx = new class_1750(new class_1838(player, hand, hit)))) != null && class_2248.method_9614((class_265)placement_state.method_26220((class_1922)world, pos)) && !(block instanceof class_2343)) {
                List<class_2680> themes = block_entity.getThemes();
                if (!world.field_9236) {
                    block_entity.setTheme(placement_state, theme_index);
                }
                if (placement_state.method_26213() > 0 && themes.stream().noneMatch(theme -> theme.method_26213() > 0) && !block_entity.emitsLight()) {
                    block_entity.toggleLight();
                }
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BlockProperties.LIGHT, (Comparable)Boolean.valueOf(block_entity.emitsLight())));
                if (placement_state.method_26195((class_1922)world, pos, class_2350.field_11043) > 0 && themes.stream().noneMatch(theme -> theme.method_26195((class_1922)world, pos, class_2350.field_11043) > 0) && !block_entity.emitsRedstone()) {
                    block_entity.toggleRedstone();
                }
                if (!player.method_7337()) {
                    held.method_7934(1);
                }
                world.method_8396(player, pos, placement_state.method_26231().method_10598(), class_3419.field_15245, 1.0f, 1.1f);
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    public static class_1269 useUpgrade(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof ReFramedEntity)) {
            return class_1269.field_5811;
        }
        ReFramedEntity block_entity = (ReFramedEntity)class_25862;
        class_1799 held = player.method_5998(hand);
        if (state.method_28498((class_2769)BlockProperties.LIGHT) && held.method_7909() == class_1802.field_8601) {
            block_entity.toggleLight();
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)BlockProperties.LIGHT, (Comparable)Boolean.valueOf(block_entity.emitsLight())));
            world.method_8396(player, pos, class_3417.field_14583, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (held.method_7909() == class_1802.field_8530) {
            block_entity.toggleRedstone();
            world.method_8396(player, pos, class_3417.field_14962, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        if (held.method_7909() == class_1802.field_8882) {
            block_entity.toggleSolidity();
            world.method_8396(player, pos, class_3417.field_14890, class_3419.field_15245, 1.0f, 1.0f);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    public static boolean cursorMatchesFace(class_265 shape, class_243 pos) {
        Map<class_2350.class_2351, Double> axes = Arrays.stream(class_2350.class_2351.values()).collect(Collectors.toMap(x -> x, x -> x.method_10172(pos.method_10216(), pos.method_10214(), pos.method_10215())));
        return shape.method_1090().stream().anyMatch(box -> axes.keySet().stream().map(x -> box.method_1001(x) <= (Double)axes.get(x) && box.method_990(x) >= (Double)axes.get(x)).reduce((prev, current) -> prev != false && current != false).orElse(false));
    }
}

