/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.u_team.music_player.MusicPlayerMod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class ClientConfig {
    private static transient ClientConfig INSTANCE = new ClientConfig();
    public boolean internalPlaylists = false;

    public static ClientConfig getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        BufferedWriter writer;
        ClientConfig config;
        Gson gson;
        Path path;
        block29: {
            path = FabricLoader.getInstance().getConfigDir().resolve("musicplayer.json");
            gson = new GsonBuilder().setPrettyPrinting().create();
            config = null;
            try {
                if (!Files.exists(path, new LinkOption[0])) {
                    config = new ClientConfig();
                    writer = Files.newBufferedWriter(path, new OpenOption[0]);
                    try {
                        gson.toJson((Object)config, (Appendable)writer);
                        break block29;
                    }
                    finally {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                }
                try (BufferedReader reader = Files.newBufferedReader(path);){
                    config = (ClientConfig)gson.fromJson((Reader)reader, ClientConfig.class);
                }
            }
            catch (IOException ex) {
                MusicPlayerMod.LOGGER.error("Could not read musicplayer config file at " + String.valueOf(path), (Throwable)ex);
            }
        }
        if (config == null) {
            config = new ClientConfig();
            try {
                writer = Files.newBufferedWriter(path, new OpenOption[0]);
                try {
                    gson.toJson((Object)config, (Appendable)writer);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        ClientConfig clientConfig = INSTANCE;
        synchronized (clientConfig) {
            INSTANCE = config;
        }
    }
}

