/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.controls;

import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.music_player.gui.BetterNestedGui;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiMusicProgressBar;
import info.u_team.music_player.gui.controls.GuiVolumeSlider;
import info.u_team.music_player.gui.settings.GuiMusicPlayerSettings;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.settings.Repeat;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.u_team_core.gui.elements.ImageActivatableButton;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ImageToggleButton;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GuiControls
extends AbstractContainerEventHandler
implements BetterNestedGui,
Renderable,
NarratableEntry {
    private final int middleX;
    private final int y;
    private final int width;
    private final int buttonSize;
    private final int halfButtonSize;
    private final List<AbstractWidget> buttons;
    private final List<AbstractWidget> disableButtons;
    private final List<GuiEventListener> children;
    private final ITrackManager manager;
    private final ImageToggleButton playButton;
    private final GuiMusicProgressBar songProgress;
    private final ScrollingText titleRender;
    private final ScrollingText authorRender;

    public GuiControls(Screen gui, int y, int width) {
        boolean isIngame;
        this.y = y;
        this.width = width;
        this.middleX = width / 2;
        this.buttons = new ArrayList<AbstractWidget>();
        this.disableButtons = new ArrayList<AbstractWidget>();
        this.children = new ArrayList<GuiEventListener>();
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        Minecraft mc = Minecraft.m_91087_();
        boolean isSettings = gui instanceof GuiMusicPlayerSettings;
        boolean small = isIngame = gui instanceof PauseScreen;
        this.buttonSize = small ? 15 : 20;
        this.halfButtonSize = this.buttonSize / 2;
        this.playButton = this.addButton(new ImageToggleButton(this.middleX - this.halfButtonSize, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_PAUSE, !this.manager.isPaused()));
        this.playButton.setPressable(() -> {
            boolean play = this.playButton.isToggled();
            this.manager.setPaused(!play);
        });
        ImageButton skipForwardButton = this.addButton(new ImageButton(this.middleX + this.halfButtonSize + 5, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SKIP_FORWARD));
        skipForwardButton.setPressable(() -> MusicPlayerUtils.skipForward());
        ImageButton skipBackButton = this.addButton(new ImageButton(this.middleX - (this.buttonSize + this.halfButtonSize + 5), y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SKIP_BACK));
        skipBackButton.setPressable(() -> MusicPlayerUtils.skipBack());
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        ImageActivatableButton shuffleButton = this.addButton(new ImageActivatableButton(this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10), y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_SHUFFLE, settings.isShuffle(), MusicPlayerColors.LIGHT_GREEN));
        shuffleButton.setPressable(() -> {
            settings.setShuffle(!settings.isShuffle());
            shuffleButton.setActivated(settings.isShuffle());
        });
        ImageActivatableButton repeatButton = this.addButton(new ImageActivatableButton(this.middleX + this.buttonSize + this.halfButtonSize + 10, y, this.buttonSize, this.buttonSize, MusicPlayerResources.TEXTURE_REPEAT, settings.getRepeat().isActive(), MusicPlayerColors.LIGHT_GREEN));
        repeatButton.setImage(settings.getRepeat().getResource());
        repeatButton.setPressable(() -> {
            settings.setRepeat(Repeat.forwardCycle(settings.getRepeat()));
            repeatButton.setActivated(settings.getRepeat().isActive());
            repeatButton.setImage(settings.getRepeat().getResource());
        });
        this.songProgress = new GuiMusicProgressBar(this.manager, this.middleX - (small ? 50 : 100), y + (small ? 20 : 30), small ? 100 : 200, small ? 3 : 5, small ? 0.5f : 1.0f);
        this.children.add((GuiEventListener)this.songProgress);
        if (!isSettings) {
            ImageButton settingsButton = this.addButtonNonDisable(new ImageButton(width - 16, 1, 15, 15, MusicPlayerResources.TEXTURE_SETTINGS));
            settingsButton.setPressable(() -> mc.m_91152_((Screen)new GuiMusicPlayerSettings(gui)));
        }
        if (isIngame) {
            ImageButton guiButton = this.addButtonNonDisable(new ImageButton(width - 32, 1, 15, 15, MusicPlayerResources.TEXTURE_OPEN));
            guiButton.setPressable(() -> mc.m_91152_((Screen)new GuiMusicPlayer()));
        }
        int volumeY = width - (70 + (isIngame ? 33 : (!isSettings ? 17 : 1)));
        GuiVolumeSlider volumeSlider = this.addButtonNonDisable(new GuiVolumeSlider(volumeY, 1, 70, 15, Component.m_130674_((String)(MusicPlayerLocalization.getTranslation("gui.controls.volume", new Object[0]) + ": ")), Component.m_130674_((String)"%"), 0.0, 100.0, settings.getVolume(), false, true, slider -> {
            settings.setVolume(slider.getValueInt());
            MusicPlayerManager.getPlayer().setVolume(settings.getVolume());
        }));
        volumeSlider.setScale(0.7f);
        int textRenderWidth = this.middleX - (2 * this.buttonSize + this.halfButtonSize + 10) - (small ? 15 : 35);
        int textRenderY = small ? y : y + 2;
        this.titleRender = new ScrollingText(mc.f_91062_, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()), small ? 10.0f : 25.0f, (float)textRenderY);
        this.titleRender.setWidth(textRenderWidth);
        this.titleRender.setStepSize(0.5f);
        this.titleRender.setColor(MusicPlayerColors.YELLOW);
        this.titleRender.setSpeedTime(35);
        this.authorRender = new ScrollingText(mc.f_91062_, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()), small ? 10.0f : 25.0f, (float)(textRenderY + 10));
        this.authorRender.setWidth(textRenderWidth);
        this.authorRender.setStepSize(0.5f);
        this.authorRender.setColor(MusicPlayerColors.YELLOW);
        this.authorRender.setScale(0.75f);
        this.authorRender.setSpeedTime(35);
        this.disableButtons.forEach(button -> {
            button.f_93623_ = false;
        });
        this.buttons.forEach(this.children::add);
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    public void tick() {
        if (this.manager.getCurrentTrack() == null) {
            this.disableButtons.forEach(button -> {
                button.f_93623_ = false;
            });
        } else {
            this.disableButtons.forEach(button -> {
                button.f_93623_ = true;
            });
        }
        this.playButton.setToggled(!this.manager.isPaused());
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_166856_();
        this.buttons.forEach(button -> button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks));
        this.songProgress.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.titleRender.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.authorRender.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        poseStack.m_85849_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.manager.getCurrentTrack() != null && button == 0 && (this.checkClick(this.titleRender, mouseX, mouseY) || this.checkClick(this.authorRender, mouseX, mouseY)) && GuiTrackUtils.openURI(this.manager.getCurrentTrack().getInfo().getURI())) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkClick(ScrollingText renderer, double mouseX, double mouseY) {
        if (!(mouseX >= (double)renderer.getX())) return false;
        if (!(mouseY >= (double)renderer.getY())) return false;
        if (!(mouseX < (double)(renderer.getX() + (float)renderer.getWidth()))) return false;
        float f = renderer.getY();
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        if (!(mouseY < (double)(f + (float)(9 + 1) * renderer.getScale()))) return false;
        return true;
    }

    private <B extends AbstractWidget> B addButton(B button) {
        this.buttons.add(button);
        this.disableButtons.add(button);
        return button;
    }

    private <B extends AbstractWidget> B addButtonNonDisable(B button) {
        this.buttons.add(button);
        return button;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public ScrollingText getTitleRender() {
        return this.titleRender;
    }

    public ScrollingText getAuthorRender() {
        return this.authorRender;
    }

    public void copyTitleRendererState(ScrollingText renderer) {
        this.titleRender.copyState(renderer);
    }

    public void copyAuthorRendererState(ScrollingText renderer) {
        this.authorRender.copyState(renderer);
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public boolean m_142518_() {
        return false;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }
}

