/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.playlist.GuiMusicPlaylistList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlayable;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.music_player.util.WrappedObject;
import info.u_team.u_team_core.gui.elements.ImageButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;

abstract class GuiMusicPlaylistListEntryFunctions
extends GuiMusicPlaylistListEntryPlayable {
    protected final Playlist playlist;
    protected final WrappedObject<String> uri;
    protected final ImageButton deleteTrackButton;
    protected final ImageButton upButton;
    protected final ImageButton downButton;

    GuiMusicPlaylistListEntryFunctions(GuiMusicPlaylistList guilist, Playlists playlists, Playlist playlist, LoadedTracks loadedTrack, IAudioTrack track) {
        super(playlists, playlist, loadedTrack, track);
        this.playlist = playlist;
        this.uri = loadedTrack.getUri();
        this.deleteTrackButton = (ImageButton)this.addChildren((GuiEventListener)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_CLEAR));
        this.upButton = (ImageButton)this.addChildren((GuiEventListener)new ImageButton(0, 0, 20, 10, MusicPlayerResources.TEXTURE_UP));
        this.downButton = (ImageButton)this.addChildren((GuiEventListener)new ImageButton(0, 0, 20, 10, MusicPlayerResources.TEXTURE_DOWN));
        this.deleteTrackButton.setPressable(() -> {
            playlist.remove(this.uri);
            guilist.updateAllEntries();
        });
        this.upButton.setPressable(() -> {
            playlist.move(this.uri, 1);
            guilist.setSelectedEntryWhenMove(this, -1);
            guilist.updateAllEntries();
        });
        this.downButton.setPressable(() -> {
            playlist.move(this.uri, -1);
            guilist.setSelectedEntryWhenMove(this, 1);
            guilist.updateAllEntries();
        });
    }

    @Override
    public void m_6311_(GuiGraphics guiGraphics, int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        super.m_6311_(guiGraphics, slotIndex, entryY, entryX, entryWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        this.drawEntryExtended(guiGraphics, entryX, entryY, entryWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        this.deleteTrackButton.m_252865_(entryWidth - 15);
        this.deleteTrackButton.m_253211_(entryY + 8);
        this.deleteTrackButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.upButton.m_252865_(entryWidth - 40);
        this.upButton.m_253211_(entryY + 8);
        this.upButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.downButton.m_252865_(entryWidth - 40);
        this.downButton.m_253211_(entryY + 18);
        this.downButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public abstract void drawEntryExtended(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8, float var9);
}

