/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.render;

import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.lavaplayer.api.audio.IPlayingTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.u_team_core.gui.elements.ScalableText;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_4587;

public class RenderOverlayMusicDisplay
implements class_4068 {
    private final ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
    private final int width;
    private final int height;
    private final ScrollingText title;
    private final ScrollingText author;
    private final ScalableText position;
    private final ScalableText duration;

    public RenderOverlayMusicDisplay() {
        this.height = 35;
        this.width = 120;
        class_327 fontRender = class_310.method_1551().field_1772;
        this.title = new ScrollingText(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedTitle()), 3.0f, 2.0f);
        this.title.setStepSize(0.5f);
        this.title.setColor(MusicPlayerColors.YELLOW);
        this.title.setWidth(114);
        this.title.setSpeedTime(35);
        this.author = new ScrollingText(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(track -> track.getInfo().getFixedAuthor()), 3.0f, 12.0f);
        this.author.setStepSize(0.5f);
        this.author.setColor(MusicPlayerColors.YELLOW);
        this.author.setScale(0.75f);
        this.author.setWidth(114);
        this.author.setSpeedTime(35);
        this.position = new ScalableText(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedPosition), 6.0f, 28.0f);
        this.position.setColor(MusicPlayerColors.YELLOW);
        this.position.setScale(0.5f);
        this.duration = new ScalableText(fontRender, () -> GuiTrackUtils.getValueOfPlayingTrack(GuiTrackUtils::getFormattedDuration), (float)(this.width - 6), 28.0f);
        this.duration.setTextChanged(renderer -> this.duration.setX((float)(this.width - 6) - renderer.getTextWidth()));
        this.duration.setColor(MusicPlayerColors.YELLOW);
        this.duration.setScale(0.5f);
    }

    public void method_25394(class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        IPlayingTrack track = this.manager.getCurrentTrack();
        if (track == null) {
            return;
        }
        class_332.method_25294((class_4587)matrixStack, (int)0, (int)0, (int)this.width, (int)this.height, (int)-14606047);
        double progress = track.getInfo().isStream() ? 0.5 : (double)track.getPosition() / (double)track.getDuration();
        class_332.method_25294((class_4587)matrixStack, (int)6, (int)23, (int)(this.width - 6), (int)26, (int)-11184811);
        class_332.method_25294((class_4587)matrixStack, (int)6, (int)23, (int)(6 + (int)((double)(this.width - 12) * progress)), (int)26, (int)-12676864);
        this.title.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.author.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.position.method_25394(matrixStack, mouseX, mouseY, partialTicks);
        this.duration.method_25394(matrixStack, mouseX, mouseY, partialTicks);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }
}

