/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer;

import com.google.gson.Gson;
import info.u_team.music_player.init.MusicPlayerFiles;
import info.u_team.music_player.musicplayer.IGsonLoadable;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlaylistManager
implements IGsonLoadable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Gson gson;
    private final Path path;
    private Playlists playlists;

    public PlaylistManager(Gson gson) {
        this.gson = gson;
        this.path = MusicPlayerFiles.getDirectory().resolve("playlist.json.gz");
    }

    @Override
    public void loadFromFile() {
        block11: {
            try {
                if (!Files.exists(this.path, new LinkOption[0])) {
                    this.playlists = new Playlists();
                    this.writeToFile();
                    break block11;
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(Files.newInputStream(this.path, new OpenOption[0])), "UTF-8"));){
                    this.playlists = (Playlists)this.gson.fromJson((Reader)reader, Playlists.class);
                }
            }
            catch (ZipException ex) {
                LOGGER.warn("The playlist file is corrupted and will be deleted at " + this.path, (Throwable)ex);
                this.playlists = new Playlists();
            }
            catch (IOException ex) {
                LOGGER.error("Could not read playlist file at " + this.path, (Throwable)ex);
            }
        }
    }

    @Override
    public void writeToFile() {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(Files.newOutputStream(this.path, new OpenOption[0])), "UTF-8"));){
            this.gson.toJson((Object)this.playlists, (Appendable)writer);
        }
        catch (IOException ex) {
            LOGGER.error("Could not write playlist file at " + this.path, (Throwable)ex);
        }
    }

    public Playlists getPlaylists() {
        return this.playlists;
    }
}

