/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.init;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.init.MusicPlayerKeys;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.MusicPlayerUtils;
import info.u_team.music_player.musicplayer.SettingsManager;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.render.RenderOverlayMusicDisplay;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class MusicPlayerEventHandler {
    private static final SettingsManager settingsManager = MusicPlayerManager.getSettingsManager();
    private static RenderOverlayMusicDisplay overlayRender;
    private static ScrollingText titleRender;
    private static ScrollingText authorRender;

    private static void onKeyInput(InputEvent.Key event) {
        MusicPlayerEventHandler.handleKeyboard(false, -1, -1);
    }

    private static void onKeyboardPressed(ScreenEvent.KeyPressed.Post event) {
        if (settingsManager.getSettings().isKeyWorkInGui()) {
            event.setCanceled(MusicPlayerEventHandler.handleKeyboard(true, event.getKeyCode(), event.getScanCode()));
        }
    }

    private static boolean handleKeyboard(boolean gui, int keyCode, int scanCode) {
        boolean handled;
        ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
        if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.OPEN, gui, keyCode, scanCode)) {
            Minecraft mc = Minecraft.m_91087_();
            if (!(mc.f_91080_ instanceof GuiMusicPlayer)) {
                mc.m_91152_((Screen)new GuiMusicPlayer());
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.PAUSE, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                manager.setPaused(!manager.isPaused());
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.SKIP_FORWARD, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipForward();
            }
            handled = true;
        } else if (MusicPlayerEventHandler.isKeyDown(MusicPlayerKeys.SKIP_BACK, gui, keyCode, scanCode)) {
            if (manager.getCurrentTrack() != null) {
                MusicPlayerUtils.skipBack();
            }
            handled = true;
        } else {
            handled = false;
        }
        return handled;
    }

    private static boolean isKeyDown(KeyMapping binding, boolean gui, int keyCode, int scanCode) {
        if (gui) {
            return binding.isActiveAndMatches(InputConstants.m_84827_((int)keyCode, (int)scanCode));
        }
        return binding.m_90859_();
    }

    private static void onRenderGameOverlay(RenderGuiOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.getOverlay() == VanillaGuiOverlay.DEBUG_TEXT.type() && settingsManager.getSettings().isShowIngameOverlay()) {
            IngameOverlayPosition position = settingsManager.getSettings().getIngameOverlayPosition();
            if (overlayRender == null) {
                overlayRender = new RenderOverlayMusicDisplay();
            }
            Window window = mc.m_91268_();
            int screenWidth = window.m_85445_();
            int screenHeight = window.m_85446_();
            int height = overlayRender.getHeight();
            int width = overlayRender.getWidth();
            int x = position.isLeft() ? 3 : screenWidth - 3 - width;
            int y = position.isUp() ? 3 : screenHeight - 3 - height;
            PoseStack poseStack = event.getPoseStack();
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 500.0f);
            overlayRender.m_86412_(poseStack, 0, 0, event.getPartialTick());
            poseStack.m_85849_();
        }
    }

    private static void onInitGuiPre(ScreenEvent.Init.Pre event) {
        Screen gui = event.getScreen();
        if (gui instanceof PauseScreen && settingsManager.getSettings().isShowIngameMenueOverlay()) {
            gui.m_6702_().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> {
                titleRender = controls.getTitleRender();
                authorRender = controls.getAuthorRender();
            });
        }
    }

    private static void onInitGuiPost(ScreenEvent.Init.Post event) {
        Screen gui = event.getScreen();
        if (gui instanceof PauseScreen && settingsManager.getSettings().isShowIngameMenueOverlay()) {
            GuiControls controls = new GuiControls(gui, 3, gui.f_96543_);
            if (titleRender != null) {
                controls.copyTitleRendererState(titleRender);
                titleRender = null;
            }
            if (authorRender != null) {
                controls.copyAuthorRendererState(authorRender);
                authorRender = null;
            }
            List list = gui.m_6702_();
            list.add(controls);
        }
    }

    private static void onDrawScreenPost(ScreenEvent.Render.Post event) {
        Screen gui = event.getScreen();
        if (gui instanceof PauseScreen && settingsManager.getSettings().isShowIngameMenueOverlay()) {
            gui.m_6702_().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> controls.m_86412_(event.getPoseStack(), event.getMouseX(), event.getMouseY(), event.getPartialTick()));
        }
    }

    private static void onMouseReleasePre(ScreenEvent.MouseButtonReleased.Pre event) {
        Screen gui = event.getScreen();
        if (gui instanceof PauseScreen && settingsManager.getSettings().isShowIngameMenueOverlay()) {
            gui.m_6702_().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(controls -> controls.m_6348_(event.getMouseX(), event.getMouseY(), event.getButton()));
        }
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        Screen gui;
        if (event.phase == TickEvent.Phase.END && (gui = Minecraft.m_91087_().f_91080_) instanceof PauseScreen && settingsManager.getSettings().isShowIngameMenueOverlay()) {
            gui.m_6702_().stream().filter(element -> element instanceof GuiControls).map(element -> (GuiControls)element).findAny().ifPresent(GuiControls::tick);
        }
    }

    public static void registerForge(IEventBus bus) {
        bus.addListener(MusicPlayerEventHandler::onKeyInput);
        bus.addListener(MusicPlayerEventHandler::onKeyboardPressed);
        bus.addListener(MusicPlayerEventHandler::onRenderGameOverlay);
        bus.addListener(MusicPlayerEventHandler::onInitGuiPre);
        bus.addListener(MusicPlayerEventHandler::onInitGuiPost);
        bus.addListener(MusicPlayerEventHandler::onDrawScreenPost);
        bus.addListener(MusicPlayerEventHandler::onMouseReleasePre);
        bus.addListener(MusicPlayerEventHandler::onClientTick);
    }
}

