/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer;

import com.google.gson.Gson;
import info.u_team.music_player.musicplayer.IGsonLoadable;
import info.u_team.music_player.musicplayer.settings.Settings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SettingsManager
implements IGsonLoadable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Gson gson;
    private Path path;
    private Settings settings;

    SettingsManager(Gson gson) {
        this.gson = gson;
    }

    @Override
    public void setBasePath(Path basePath) {
        this.path = basePath.resolve("settings.json");
    }

    @Override
    public void loadFromFile() {
        block12: {
            try {
                if (!Files.exists(this.path, new LinkOption[0])) {
                    this.settings = new Settings();
                    this.writeToFile();
                    break block12;
                }
                try (BufferedReader reader = Files.newBufferedReader(this.path);){
                    this.settings = (Settings)this.gson.fromJson((Reader)reader, Settings.class);
                    if (this.settings == null) {
                        this.settings = new Settings();
                        this.writeToFile();
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.error("Could not ready playlist file at " + this.path, (Throwable)ex);
            }
        }
    }

    @Override
    public void writeToFile() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.path, new OpenOption[0]);){
            this.gson.toJson((Object)this.settings, (Appendable)writer);
        }
        catch (IOException ex) {
            LOGGER.error("Could not write playlist file at " + this.path, (Throwable)ex);
        }
    }

    public Settings getSettings() {
        return this.settings;
    }
}

