/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui;

import info.u_team.u_team_core.gui.elements.ScrollableList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.util.Mth;

public class BetterScrollableList<T extends ObjectSelectionList.Entry<T>>
extends ScrollableList<T> {
    public BetterScrollableList(int x, int y, int width, int height, int slotHeight, int sideDistance) {
        super(x, y, width <= 0 ? 1 : width, height <= 0 ? 1 : height, slotHeight, sideDistance);
        this.setRenderHeader(false, 0);
        this.setRenderTransparentBorder(true);
    }

    public void updateSettings(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width <= 0 ? 1 : width);
        this.setHeight(height <= 0 ? 1 : height);
    }

    protected boolean isValidMouseClick(int button) {
        return button >= 0 && button <= 2;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.getFocused() != null && this.isDragging() && button == 0) {
            ((ObjectSelectionList.Entry)this.getFocused()).mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        if (button != 0 || !this.scrolling) {
            return false;
        }
        if (mouseY < (double)this.getY()) {
            this.setScrollAmount(0.0);
        } else if (mouseY > (double)this.getBottom()) {
            this.setScrollAmount(this.getMaxScroll());
        } else {
            double maxScroll = Math.max(1, this.getMaxScroll());
            int height = this.height;
            int clamped = Mth.clamp((int)((int)((float)(height * height) / (float)this.getMaxPosition())), (int)32, (int)(height - 8));
            double scoll = Math.max(1.0, maxScroll / (double)(height - clamped));
            this.setScrollAmount(this.getScrollAmount() + dragY * scoll);
        }
        return true;
    }
}

