/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.GuiMusicPlayerList;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class GuiMusicPlayer
extends BetterScreen {
    private EditBox namePlaylistField;
    private GuiMusicPlayerList playlistsList;
    private GuiControls controls;

    public GuiMusicPlayer() {
        super((Component)Component.literal((String)"musicplayer"));
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK, button -> this.minecraft.setScreen(null)));
        this.namePlaylistField = new EditBox(this.font, 100, 60, this.width - 150, 20, Component.nullToEmpty(null));
        this.namePlaylistField.setMaxLength(500);
        this.addWidget((GuiEventListener)this.namePlaylistField);
        ImageButton addPlaylistButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.width - 41, 59, 22, 22, MusicPlayerResources.TEXTURE_CREATE));
        addPlaylistButton.setPressable(() -> {
            String name = this.namePlaylistField.getValue();
            if (StringUtils.isBlank((CharSequence)name) || name.equals(MusicPlayerLocalization.getTranslation("gui.musicplayer.create_playlist.insert_name", new Object[0]))) {
                this.namePlaylistField.setValue(MusicPlayerLocalization.getTranslation("gui.musicplayer.create_playlist.insert_name", new Object[0]));
                return;
            }
            this.playlistsList.addPlaylist(name);
            this.namePlaylistField.setValue("");
        });
        this.playlistsList = new GuiMusicPlayerList(12, 90, this.width - 24, this.height - 100);
        this.addWidget((GuiEventListener)this.playlistsList);
        this.controls = new GuiControls(this, 5, this.width);
        this.addWidget((GuiEventListener)this.controls);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String text = this.namePlaylistField.getValue();
        ScrollingText titleRender = this.controls.getTitleRender();
        ScrollingText authorRender = this.controls.getAuthorRender();
        this.init(minecraft, width, height);
        this.namePlaylistField.setValue(text);
        this.controls.copyTitleRendererState(titleRender);
        this.controls.copyAuthorRendererState(authorRender);
    }

    public void tick() {
        this.controls.tick();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.playlistsList.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, MusicPlayerLocalization.getTranslation("gui.musicplayer.create_playlist.add_list", new Object[0]), 20, 65, 0xFFFFFF, false);
        this.namePlaylistField.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.controls.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public GuiMusicPlayerList getPlaylistsList() {
        return this.playlistsList;
    }
}

