/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.controls;

import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.lavaplayer.api.audio.IPlayingTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.u_team_core.gui.elements.ProgressBar;
import info.u_team.u_team_core.gui.elements.ScalableText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;

public class GuiMusicProgressBar
extends ProgressBar {
    private final ScalableText positionRender;
    private final ScalableText durationRender;

    public GuiMusicProgressBar(ITrackManager manager, int x, int y, int width, int height, float scale) {
        super(x, y, width, height, MusicPlayerColors.GREY, MusicPlayerColors.GREEN, () -> GuiMusicProgressBar.getProgress(manager), value -> GuiMusicProgressBar.updateProgress(manager, value));
        Font fontRender = Minecraft.getInstance().font;
        this.positionRender = new ScalableText(fontRender, () -> GuiTrackUtils.getFormattedPosition(manager.getCurrentTrack()), (float)x, (float)y);
        this.positionRender.setScale(scale);
        this.positionRender.setColor(MusicPlayerColors.YELLOW);
        this.positionRender.setTextChanged(renderer -> {
            renderer.setX((float)this.getX() - renderer.getTextWidth() - (float)(renderer.getScale() < 1.0f ? 3 : 5));
            renderer.setY((float)(this.getY() - (renderer.getScale() < 1.0f ? 1 : 2)));
        });
        this.durationRender = new ScalableText(fontRender, () -> GuiTrackUtils.getFormattedDuration(manager.getCurrentTrack()), (float)x, (float)y);
        this.durationRender.setScale(scale);
        this.durationRender.setColor(MusicPlayerColors.YELLOW);
        this.durationRender.setTextChanged(renderer -> {
            renderer.setX((float)(this.getX() + this.getWidth() + (renderer.getScale() < 1.0f ? 3 : 5)));
            renderer.setY((float)(this.getY() - (renderer.getScale() < 1.0f ? 1 : 2)));
        });
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.positionRender.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.durationRender.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private static double getProgress(ITrackManager manager) {
        IPlayingTrack track = manager.getCurrentTrack();
        if (track == null) {
            return 0.0;
        }
        if (track.getInfo().isStream()) {
            return 0.5;
        }
        return (double)track.getPosition() / (double)track.getDuration();
    }

    private static void updateProgress(ITrackManager manager, double value) {
        IPlayingTrack track = manager.getCurrentTrack();
        if (track != null) {
            track.setPosition((long)((double)track.getDuration() * value));
        }
    }
}

