/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistList;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearch;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class GuiMusicPlaylist
extends BetterScreen {
    private final Playlist playlist;
    private final GuiMusicPlaylistList trackList;
    private ImageButton addTracksButton;
    private GuiControls controls;

    public GuiMusicPlaylist(Playlist playlist) {
        super((Component)Component.literal((String)"musicplaylist"));
        this.playlist = playlist;
        this.trackList = new GuiMusicPlaylistList(playlist);
        if (!playlist.isLoaded()) {
            playlist.load(() -> {
                if (Minecraft.getInstance().screen == this) {
                    Minecraft.getInstance().execute(() -> {
                        if (Minecraft.getInstance().screen == this) {
                            this.trackList.addAllEntries();
                            if (this.addTracksButton != null) {
                                this.addTracksButton.active = true;
                            }
                        }
                    });
                }
            });
        }
    }

    protected void init() {
        ImageButton backButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK));
        backButton.setPressable(() -> this.minecraft.setScreen((Screen)new GuiMusicPlayer()));
        this.addTracksButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.width - 35, 20, 22, 22, MusicPlayerResources.TEXTURE_ADD));
        this.addTracksButton.setPressable(() -> this.minecraft.setScreen((Screen)new GuiMusicSearch(this.playlist)));
        if (!this.playlist.isLoaded()) {
            this.addTracksButton.active = false;
        }
        this.trackList.updateSettings(12, 50, this.width - 24, this.height - 60);
        this.trackList.addAllEntries();
        this.addWidget((GuiEventListener)this.trackList);
        this.controls = new GuiControls(this, 5, this.width);
        this.addWidget((GuiEventListener)this.controls);
    }

    public void tick() {
        this.controls.tick();
        this.trackList.tick();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        ScrollingText titleRender = this.controls.getTitleRender();
        ScrollingText authorRender = this.controls.getAuthorRender();
        this.init(minecraft, width, height);
        this.controls.copyTitleRendererState(titleRender);
        this.controls.copyAuthorRendererState(authorRender);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.trackList.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.controls.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public GuiMusicPlaylistList getTrackList() {
        return this.trackList;
    }
}

