/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.settings;

import info.u_team.music_player.gui.BetterScreen;
import info.u_team.music_player.gui.controls.GuiControls;
import info.u_team.music_player.gui.settings.GuiMusicPlayerSettingsMixerDeviceList;
import info.u_team.music_player.init.MusicPlayerColors;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.settings.IngameOverlayPosition;
import info.u_team.music_player.musicplayer.settings.Settings;
import info.u_team.u_team_core.gui.elements.ActivatableButton;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ScrollingText;
import info.u_team.u_team_core.gui.elements.UButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class GuiMusicPlayerSettings
extends BetterScreen {
    private final Screen previousGui;
    private GuiMusicPlayerSettingsMixerDeviceList mixerDeviceList;
    private GuiControls controls;

    public GuiMusicPlayerSettings(Screen previousGui) {
        super((Component)Component.literal((String)"musicplayersettings"));
        this.previousGui = previousGui;
    }

    protected void init() {
        this.addRenderableWidget((GuiEventListener)new ImageButton(1, 1, 15, 15, MusicPlayerResources.TEXTURE_BACK, button -> this.minecraft.setScreen(this.previousGui)));
        Settings settings = MusicPlayerManager.getSettingsManager().getSettings();
        ActivatableButton toggleKeyWorkInGuiButton = (ActivatableButton)this.addRenderableWidget((GuiEventListener)new ActivatableButton(12, 60, this.width / 2 - 24, 20, Component.nullToEmpty((String)MusicPlayerLocalization.getTranslation("gui.settings.toggle.key_in_gui", new Object[0])), settings.isKeyWorkInGui(), MusicPlayerColors.LIGHT_GREEN));
        toggleKeyWorkInGuiButton.setPressable(() -> {
            settings.setKeyWorkInGui(!settings.isKeyWorkInGui());
            toggleKeyWorkInGuiButton.setActivated(settings.isKeyWorkInGui());
        });
        ActivatableButton toggleIngameMenueDisplayButton = (ActivatableButton)this.addRenderableWidget((GuiEventListener)new ActivatableButton(this.width / 2 + 14, 60, this.width / 2 - 24, 20, Component.nullToEmpty((String)MusicPlayerLocalization.getTranslation("gui.settings.toggle.menue_overlay", new Object[0])), settings.isShowIngameMenueOverlay(), MusicPlayerColors.LIGHT_GREEN));
        toggleIngameMenueDisplayButton.setPressable(() -> {
            settings.setShowIngameMenueOverlay(!settings.isShowIngameMenueOverlay());
            toggleIngameMenueDisplayButton.setActivated(settings.isShowIngameMenueOverlay());
        });
        ActivatableButton toggleIngameDisplayButton = (ActivatableButton)this.addRenderableWidget((GuiEventListener)new ActivatableButton(12, 90, this.width / 2 - 24, 20, Component.nullToEmpty((String)MusicPlayerLocalization.getTranslation("gui.settings.toggle.ingame_overlay", new Object[0])), settings.isShowIngameOverlay(), MusicPlayerColors.LIGHT_GREEN));
        toggleIngameDisplayButton.setPressable(() -> {
            settings.setShowIngameOverlay(!settings.isShowIngameOverlay());
            toggleIngameDisplayButton.setActivated(settings.isShowIngameOverlay());
        });
        UButton ingameOverlayPositionButton = (UButton)this.addRenderableWidget((GuiEventListener)new UButton(this.width / 2 + 14, 90, this.width / 2 - 24, 20, Component.nullToEmpty((String)(MusicPlayerLocalization.getTranslation("gui.settings.position.overlay", new Object[0]) + ": " + MusicPlayerLocalization.getTranslation(settings.getIngameOverlayPosition().getLocalization(), new Object[0])))));
        ingameOverlayPositionButton.setPressable(() -> {
            settings.setIngameOverlayPosition(IngameOverlayPosition.forwardCycle(settings.getIngameOverlayPosition()));
            ingameOverlayPositionButton.setMessage(Component.nullToEmpty((String)(MusicPlayerLocalization.getTranslation("gui.settings.position.overlay", new Object[0]) + ": " + MusicPlayerLocalization.getTranslation(settings.getIngameOverlayPosition().getLocalization(), new Object[0]))));
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(this, 12, 120, this.width / 2 - 24, 20, CommonComponents.EMPTY, MusicPlayerManager.getPlayer().getSpeed() / 4.0f){
            {
                this.updateMessage();
            }

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)(MusicPlayerLocalization.getTranslation("gui.settings.speed", new Object[0]) + ": " + (float)Math.round(MusicPlayerManager.getPlayer().getSpeed() * 100.0f) / 100.0f)));
            }

            protected void applyValue() {
                MusicPlayerManager.getPlayer().setSpeed((float)Mth.clampedLerp((double)0.1f, (double)4.0, (double)this.value));
            }
        });
        this.addRenderableWidget((GuiEventListener)new AbstractSliderButton(this, this.width / 2 + 14, 120, this.width / 2 - 24, 20, CommonComponents.EMPTY, MusicPlayerManager.getPlayer().getPitch() / 3.0f){
            {
                this.updateMessage();
            }

            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)(MusicPlayerLocalization.getTranslation("gui.settings.pitch", new Object[0]) + ": " + (float)Math.round(MusicPlayerManager.getPlayer().getPitch() * 100.0f) / 100.0f)));
            }

            protected void applyValue() {
                MusicPlayerManager.getPlayer().setPitch((float)Mth.clampedLerp((double)0.1f, (double)3.0, (double)this.value));
            }
        });
        this.mixerDeviceList = new GuiMusicPlayerSettingsMixerDeviceList(12, 163, this.width - 24, this.height - 173);
        this.addWidget((GuiEventListener)this.mixerDeviceList);
        this.controls = new GuiControls(this, 5, this.width);
        this.addWidget((GuiEventListener)this.controls);
    }

    public void tick() {
        this.controls.tick();
    }

    public void resize(Minecraft minecraft, int width, int height) {
        ScrollingText titleRender = this.controls.getTitleRender();
        ScrollingText authorRender = this.controls.getAuthorRender();
        this.init(minecraft, width, height);
        this.controls.copyTitleRendererState(titleRender);
        this.controls.copyAuthorRendererState(authorRender);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.mixerDeviceList.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.minecraft.font, MusicPlayerLocalization.getTranslation("gui.settings.mixer_device_selection", new Object[0]), 13, 147, 0xFFFFFF);
        this.controls.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
    }
}

