/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.util;

import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackInfo;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.util.TimeUtil;
import java.net.URI;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public final class GuiTrackUtils {
    private static final Minecraft MINECRAFT = Minecraft.getInstance();

    public static String trimToWith(String string, int width) {
        Object newString = GuiTrackUtils.MINECRAFT.font.plainSubstrByWidth(string, width);
        if (!((String)newString).equals(string)) {
            newString = (String)newString + "...";
        }
        return newString;
    }

    public static void addTrackInfo(GuiGraphics guiGraphics, IAudioTrack track, int x, int y, int entryWidth, int leftMargin, int titleColor) {
        int textSize = entryWidth - 150 - leftMargin;
        IAudioTrackInfo info = track.getInfo();
        String title = GuiTrackUtils.trimToWith(info.getFixedTitle(), textSize);
        String author = GuiTrackUtils.trimToWith(info.getFixedAuthor(), textSize);
        String duration = GuiTrackUtils.getFormattedDuration(track);
        guiGraphics.drawString(GuiTrackUtils.MINECRAFT.font, title, x + leftMargin, y + 5, titleColor, false);
        guiGraphics.drawString(GuiTrackUtils.MINECRAFT.font, author, x + leftMargin + 4, y + 25, 14183708, false);
        guiGraphics.drawString(GuiTrackUtils.MINECRAFT.font, duration, x + entryWidth - 140, y + 15, 0xFFFF00, false);
    }

    public static boolean openURI(String uri) {
        Style style = Component.nullToEmpty(null).getStyle();
        try {
            new URI(uri);
            style = style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, uri));
        }
        catch (Exception ex) {
            style = style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, uri));
        }
        return GuiTrackUtils.MINECRAFT.screen.handleComponentClicked(style);
    }

    public static String getFormattedDuration(IAudioTrack track) {
        long seconds;
        if (track == null) {
            seconds = 0L;
        } else {
            IAudioTrackInfo info = track.getInfo();
            if (info.isStream()) {
                return MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
            }
            seconds = track.getDuration() / 1000L;
        }
        return TimeUtil.timeConversion(seconds);
    }

    public static String getFormattedPosition(IAudioTrack track) {
        return TimeUtil.timeConversion(track == null ? 0L : track.getPosition() / 1000L);
    }

    public static <T> T getValueOfPlayingTrack(Function<IAudioTrack, T> function) {
        return GuiTrackUtils.getValueOfNullableTrack(MusicPlayerManager.getPlayer().getTrackManager().getCurrentTrack(), function);
    }

    public static <T> T getValueOfNullableTrack(IAudioTrack track, Function<IAudioTrack, T> function) {
        if (track != null) {
            return function.apply(track);
        }
        return null;
    }
}

