/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui;

import info.u_team.music_player.gui.BetterScrollableListEntry;
import info.u_team.music_player.gui.GuiMusicPlayer;
import info.u_team.music_player.gui.GuiMusicPlayerList;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylist;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.music_player.musicplayer.playlist.Skip;
import info.u_team.u_team_core.gui.elements.ImageButton;
import info.u_team.u_team_core.gui.elements.ImageToggleButton;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.tuple.Pair;

class GuiMusicPlayerListEntry
extends BetterScrollableListEntry<GuiMusicPlayerListEntry> {
    private final Playlists playlists;
    private final Playlist playlist;
    private final ImageToggleButton playPlaylistButton;
    private final ImageButton openPlaylistButton;
    private final ImageButton deletePlaylistButton;

    public GuiMusicPlayerListEntry(GuiMusicPlayerList gui, Playlists playlists, Playlist playlist) {
        this.playlists = playlists;
        this.playlist = playlist;
        this.playPlaylistButton = (ImageToggleButton)this.addChildren((GuiEventListener)new ImageToggleButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_STOP, playlist.equals(playlists.getPlaying())));
        this.playPlaylistButton.f_93623_ = !playlists.isPlayingLock();
        this.playPlaylistButton.setPressable(() -> {
            boolean play = this.playPlaylistButton.isToggled();
            if (playlists.isPlayingLock()) {
                return;
            }
            playlists.setPlaying(null);
            gui.m_6702_().stream().filter(entry -> entry != this).forEach(entry -> entry.playPlaylistButton.setToggled(false));
            Runnable runnable = () -> {
                ITrackManager manager = MusicPlayerManager.getPlayer().getTrackManager();
                if (play) {
                    if (!playlist.isEmpty()) {
                        playlists.setPlaying(playlist);
                        Pair<LoadedTracks, IAudioTrack> pair = playlist.getFirstTrack();
                        playlist.setPlayable((LoadedTracks)pair.getLeft(), (IAudioTrack)pair.getRight());
                        if (((LoadedTracks)pair.getLeft()).hasError() || pair.getRight() == null) {
                            playlist.skip(Skip.FORWARD);
                        }
                        manager.setTrackQueue(playlist);
                        manager.start();
                    } else {
                        playlists.setPlaying(null);
                        playlist.setStopable();
                        manager.stop();
                        this.playPlaylistButton.setToggled(false);
                    }
                } else {
                    playlists.setPlaying(null);
                    playlist.setStopable();
                    manager.stop();
                }
                playlists.removePlayingLock();
                Screen patt3291$temp = this.minecraft.f_91080_;
                if (patt3291$temp instanceof GuiMusicPlayer) {
                    GuiMusicPlayer musicplayergui = (GuiMusicPlayer)patt3291$temp;
                    GuiMusicPlayerList newGui = musicplayergui.getPlaylistsList();
                    newGui.m_6702_().forEach(entry -> {
                        entry.playPlaylistButton.f_93623_ = true;
                    });
                } else {
                    Screen patt3531$temp = this.minecraft.f_91080_;
                    if (patt3531$temp instanceof GuiMusicPlaylist) {
                        GuiMusicPlaylist musicplaylistgui = (GuiMusicPlaylist)patt3531$temp;
                        musicplaylistgui.getTrackList().updateAllEntries();
                    }
                }
            };
            gui.m_6702_().forEach(entry -> {
                entry.playPlaylistButton.f_93623_ = false;
            });
            playlists.setPlayingLock();
            if (!playlist.isLoaded()) {
                playlist.load(runnable);
            } else {
                runnable.run();
            }
        });
        this.openPlaylistButton = (ImageButton)this.addChildren((GuiEventListener)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_OPEN));
        this.openPlaylistButton.setPressable(() -> this.minecraft.m_91152_((Screen)new GuiMusicPlaylist(playlist)));
        this.deletePlaylistButton = (ImageButton)this.addChildren((GuiEventListener)new ImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_CLEAR));
        this.deletePlaylistButton.setPressable(() -> gui.removePlaylist(this));
    }

    public void m_6311_(GuiGraphics guiGraphics, int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        Object name = this.playlist.getName();
        if (((String)name).isEmpty()) {
            name = "\u00a7o" + MusicPlayerLocalization.getTranslation("gui.musicplayer.playlists.no_name", new Object[0]);
        }
        guiGraphics.m_280056_(this.minecraft.f_91062_, (String)name, entryX + 5, entryY + 5, this.playlist.equals(this.playlists.getPlaying()) ? 33791 : 0xFFF00F, false);
        guiGraphics.m_280056_(this.minecraft.f_91062_, this.playlist.getEntrySize() + " " + MusicPlayerLocalization.getTranslation(this.playlist.getEntrySize() > 1 ? "gui.musicplayer.playlists.entries" : "gui.musicplayer.playlists.entry", new Object[0]), entryX + 5, entryY + 30, 0xFFFFFF, false);
        this.playPlaylistButton.m_252865_(entryWidth - 65);
        this.playPlaylistButton.m_253211_(entryY + 12);
        this.playPlaylistButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.openPlaylistButton.m_252865_(entryWidth - 40);
        this.openPlaylistButton.m_253211_(entryY + 12);
        this.openPlaylistButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.deletePlaylistButton.m_252865_(entryWidth - 15);
        this.deletePlaylistButton.m_253211_(entryY + 12);
        this.deletePlaylistButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public Component m_142172_() {
        return CommonComponents.f_237098_;
    }
}

