/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist.search;

import info.u_team.music_player.gui.playlist.search.GuiMusicSearch;
import info.u_team.music_player.gui.playlist.search.GuiMusicSearchListEntry;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerLocalization;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrackList;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.util.TimeUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;

public class GuiMusicSearchListEntryPlaylist
extends GuiMusicSearchListEntry {
    private final IAudioTrackList trackList;
    private final String name;
    private final String duration;

    public GuiMusicSearchListEntryPlaylist(GuiMusicSearch gui, Playlist playlist, IAudioTrackList trackList) {
        this.trackList = trackList;
        this.name = trackList.getName();
        List<IAudioTrack> tracks = trackList.getTracks();
        this.duration = !tracks.parallelStream().anyMatch(track -> track.getInfo().isStream()) ? TimeUtil.timeConversion(tracks.parallelStream().mapToLong(track -> track.getDuration()).sum() / 1000L) : MusicPlayerLocalization.getTranslation("gui.track.duration_undefined", new Object[0]);
        this.addTrackButton.setPressable(() -> {
            playlist.add(trackList);
            gui.setInformation(ChatFormatting.GREEN + MusicPlayerLocalization.getTranslation("gui.search.added_list", new Object[0]), 150);
        });
    }

    @Override
    public void m_6311_(GuiGraphics guiGraphics, int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        super.m_6311_(guiGraphics, slotIndex, entryY, entryX, entryWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        guiGraphics.m_280056_(this.minecraft.f_91062_, this.name, entryX + 5, entryY + 15, 16048706, false);
        guiGraphics.m_280056_(this.minecraft.f_91062_, this.duration, entryX + entryWidth - 135, entryY + 5, 0xFFFF00, false);
    }

    public IAudioTrackList getTrackList() {
        return this.trackList;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        String uri;
        if (button == 2 && GuiTrackUtils.openURI(uri = this.trackList.getUri())) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

