/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.gui.playlist;

import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntry;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryError;
import info.u_team.music_player.gui.playlist.GuiMusicPlaylistListEntryPlaylistStart;
import info.u_team.music_player.gui.util.GuiTrackUtils;
import info.u_team.music_player.init.MusicPlayerResources;
import info.u_team.music_player.lavaplayer.api.audio.IAudioTrack;
import info.u_team.music_player.lavaplayer.api.queue.ITrackManager;
import info.u_team.music_player.musicplayer.MusicPlayerManager;
import info.u_team.music_player.musicplayer.playlist.LoadedTracks;
import info.u_team.music_player.musicplayer.playlist.Playlist;
import info.u_team.music_player.musicplayer.playlist.Playlists;
import info.u_team.u_team_core.gui.elements.ToggleImageButton;
import net.minecraft.client.gui.widget.Widget;

public abstract class GuiMusicPlaylistListEntryPlayable
extends GuiMusicPlaylistListEntry {
    private final ITrackManager manager;
    private final IAudioTrack track;
    private final LoadedTracks loadedTrack;
    protected final ToggleImageButton playTrackButton;

    GuiMusicPlaylistListEntryPlayable(Playlists playlists, Playlist playlist, LoadedTracks loadedTrack, IAudioTrack track) {
        this.track = track;
        this.loadedTrack = loadedTrack;
        this.manager = MusicPlayerManager.getPlayer().getTrackManager();
        this.playTrackButton = (ToggleImageButton)this.addButton((Widget)new ToggleImageButton(0, 0, 20, 20, MusicPlayerResources.TEXTURE_PLAY, MusicPlayerResources.TEXTURE_PAUSE));
        if (loadedTrack.hasError() || track == null) {
            this.playTrackButton.visible = false;
        } else {
            this.playTrackButton.toggle(track == this.getCurrentlyPlaying());
            this.playTrackButton.setPressable(() -> {
                boolean play = this.playTrackButton.isToggled();
                if (play) {
                    if (this.manager.isPaused() && this.getCurrentlyPlaying() == track) {
                        this.manager.setPaused(false);
                    } else {
                        playlists.setPlaying(playlist);
                        playlist.setPlayable(loadedTrack, track);
                        this.manager.setTrackQueue(playlist);
                        this.manager.start();
                    }
                } else {
                    this.manager.setPaused(true);
                }
            });
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 2) {
            String uri;
            String string = uri = this instanceof GuiMusicPlaylistListEntryPlaylistStart || this instanceof GuiMusicPlaylistListEntryError ? this.loadedTrack.getUri().get() : this.track.getInfo().getURI();
            if (GuiTrackUtils.openURI(uri)) {
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(int slotIndex, int entryY, int entryX, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        this.playTrackButton.x = entryWidth - 65;
        this.playTrackButton.y = entryY + 8;
        this.playTrackButton.render(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void tick() {
        if (this.isPlaying()) {
            this.playTrackButton.toggle(!this.manager.isPaused());
        } else {
            this.playTrackButton.toggle(false);
        }
    }

    protected IAudioTrack getCurrentlyPlaying() {
        return this.manager.getCurrentTrack() == null ? null : this.manager.getCurrentTrack().getOriginalTrack();
    }

    protected boolean isPlaying() {
        return this.getCurrentlyPlaying() == this.track;
    }

    public IAudioTrack getTrack() {
        return this.track;
    }

    public ToggleImageButton getPlayTrackButton() {
        return this.playTrackButton;
    }
}

