/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.dependency.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;

public class DependencyClassLoader
extends URLClassLoader {
    private final Collection<String> ourClassLoaderPackages = Arrays.asList("info.u_team.music_player.lavaplayer.api", "javax.script", "javax.lang", "org.slf4j");
    private final ClassLoader ourClassLoader = this.getClass().getClassLoader();

    public DependencyClassLoader() {
        super(new URL[0], (ClassLoader)null);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            if (this.ourClassLoaderPackages.stream().anyMatch(name::startsWith)) {
                return this.ourClassLoader.loadClass(name);
            }
            throw ex;
        }
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

