/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.musicplayer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.u_team.music_player.lavaplayer.api.IMusicPlayer;
import info.u_team.music_player.musicplayer.MusicPlayerFiles;
import info.u_team.music_player.musicplayer.PlaylistManager;
import info.u_team.music_player.musicplayer.SettingsManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class MusicPlayerManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static IMusicPlayer player;
    private static final Gson gson;
    private static final MusicPlayerFiles files;
    private static final PlaylistManager playListManager;
    private static final SettingsManager settingsManager;

    static void setup(ClassLoader classLoader, boolean internalPlaylists) {
        MusicPlayerManager.fixLogLevel(classLoader);
        MusicPlayerManager.generatePlayer(classLoader);
        player.startAudioOutput();
        files.load(internalPlaylists);
        playListManager.setBasePath(files.getDirectory());
        settingsManager.setBasePath(files.getDirectory());
        playListManager.loadFromFile();
        settingsManager.loadFromFile();
        player.setVolume(settingsManager.getSettings().getVolume());
    }

    private static void fixLogLevel(ClassLoader classLoader) {
        String loggerName = "org.apache.http";
        LoggerContext context = (LoggerContext)LogManager.getContext((ClassLoader)classLoader, (boolean)false);
        context.getConfiguration().addLogger("org.apache.http", new LoggerConfig("org.apache.http", Level.INFO, true));
    }

    private static void generatePlayer(ClassLoader classLoader) {
        try {
            Class<?> clazz = Class.forName("info.u_team.music_player.lavaplayer.MusicPlayer", true, classLoader);
            if (!IMusicPlayer.class.isAssignableFrom(clazz)) {
                throw new IllegalAccessError("The class " + String.valueOf(clazz) + " does not implement IMusicPlayer! This should not happen?!");
            }
            player = (IMusicPlayer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            LOGGER.info("Successfully created music player instance");
        }
        catch (Exception ex) {
            LOGGER.fatal("Cannot create music player instance. This is a serious bug and the mod will not work. Report to the mod authors", (Throwable)ex);
            System.exit(-1);
        }
    }

    public static IMusicPlayer getPlayer() {
        return player;
    }

    public static MusicPlayerFiles getFiles() {
        return files;
    }

    public static PlaylistManager getPlaylistManager() {
        return playListManager;
    }

    public static SettingsManager getSettingsManager() {
        return settingsManager;
    }

    static {
        gson = new GsonBuilder().setPrettyPrinting().create();
        files = new MusicPlayerFiles();
        playListManager = new PlaylistManager(gson);
        settingsManager = new SettingsManager(gson);
    }
}

