/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.music_player.dependency;

import com.google.common.base.Predicates;
import info.u_team.music_player.dependency.TinyFdHelper;
import info.u_team.music_player.dependency.classloader.DependencyClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.StringUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class DependencyManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER_LOAD = MarkerManager.getMarker((String)"Load");
    private static final Marker MARKER_ADD = MarkerManager.getMarker((String)"Add");
    private static final String FILE_ENDING = ".jar.packed";
    public static final DependencyClassLoader MUSICPLAYER_CLASSLOADER = new DependencyClassLoader();

    public static void load() {
        FileSystem fileSystem;
        LOGGER.info(MARKER_LOAD, "Load dependencies");
        Path tmpPath = DependencyManager.createExtractDirectory();
        LOGGER.info(MARKER_LOAD, "Extraction directory for jar files is {} ", (Object)tmpPath.toAbsolutePath());
        String devPath = System.getProperty("musicplayer.dev");
        if (devPath == null) {
            try {
                fileSystem = FileSystems.newFileSystem(DependencyManager.class.getResource("/dependencies").toURI(), Collections.emptyMap());
            }
            catch (IOException | URISyntaxException ex) {
                throw new RuntimeException("Cannot create file system for jar file", ex);
            }
        } else {
            fileSystem = null;
        }
        Set<Path> paths = devPath != null ? Collections.unmodifiableSet(Stream.of(devPath.split(";")).filter((Predicate<String>)Predicates.not(StringUtils::func_151246_b)).map(x$0 -> Paths.get(x$0, new String[0])).map(DependencyManager::findJarFilesInDev).flatMap(Collection::stream).collect(Collectors.toSet())) : DependencyManager.findJarFilesInJar(fileSystem, "dependencies");
        paths.stream().map(path -> DependencyManager.extractFile(tmpPath, path)).map(DependencyManager::pathToUrl).forEach(DependencyManager::addToMusicPlayerDependencies);
        if (devPath != null) {
            TinyFdHelper.load(Collections.emptySet());
        } else {
            Set<URL> url = DependencyManager.findJarFilesInJar(fileSystem, "tinyfd").stream().map(path -> DependencyManager.extractFile(tmpPath, path)).map(DependencyManager::pathToUrl).collect(Collectors.toSet());
            TinyFdHelper.load(url);
        }
        if (fileSystem != null) {
            try {
                fileSystem.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOGGER.info(MARKER_LOAD, "Finished loading dependencies");
    }

    private static Path createExtractDirectory() {
        try {
            Path baseDirectory = Paths.get(System.getProperty("java.io.tmpdir", "/tmp"), "musicplayer-extraction-tmp");
            Path specificDirectory = baseDirectory.resolve(String.valueOf(System.currentTimeMillis()));
            try {
                FileUtils.deleteDirectory((File)baseDirectory.toFile());
            }
            catch (Exception exception) {
                // empty catch block
            }
            Files.createDirectories(specificDirectory, new FileAttribute[0]);
            return specificDirectory;
        }
        catch (IOException unused) {
            try {
                return Files.createTempDirectory("musicplayer-extraction-tmp", new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Cannot create extract directory for musicplayer files", ex);
            }
        }
    }

    private static Path extractFile(Path extractDirectory, Path path) {
        Path extractPath = extractDirectory.resolve(path.getFileName().toString());
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
             OutputStream outputStream = Files.newOutputStream(extractPath, StandardOpenOption.CREATE);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            LOGGER.debug(MARKER_LOAD, "Copied file from ({}) to ({})", (Object)path, (Object)extractPath);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot extract file " + path + " to " + extractPath, ex);
        }
        return extractPath;
    }

    private static URL pathToUrl(Path path) {
        try {
            return path.toUri().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<Path> findJarFilesInDev(Path path) {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            Set<Path> set = DependencyManager.filterPackedFiles(stream);
            return set;
        }
        catch (IOException ex) {
            LOGGER.error(MARKER_LOAD, "When searching for jar files in dev an exception occured.", (Throwable)ex);
            return Collections.emptySet();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<Path> findJarFilesInJar(FileSystem fileSystem, String folder) {
        try (Stream<Path> stream = Files.walk(fileSystem.getPath("/" + folder, new String[0]), new FileVisitOption[0]);){
            Set<Path> set = DependencyManager.filterPackedFiles(stream);
            return set;
        }
        catch (IOException | IllegalStateException ex) {
            LOGGER.error(MARKER_LOAD, "When searching for jar files in jar an exception occured.", (Throwable)ex);
            return Collections.emptySet();
        }
    }

    private static Set<Path> filterPackedFiles(Stream<Path> stream) {
        return stream.filter(file -> file.toString().endsWith(FILE_ENDING)).collect(Collectors.toSet());
    }

    private static void addToMusicPlayerDependencies(URL url) {
        MUSICPLAYER_CLASSLOADER.addURL(url);
        LOGGER.debug(MARKER_ADD, "Added new jar file ({}) to the musicplayer dependency classloader.", (Object)url);
    }
}

