/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.gui.elements.backport;

import com.google.common.collect.Lists;
import info.u_team.u_team_core.gui.elements.backport.GuiSlotNew;
import info.u_team.u_team_core.gui.elements.backport.IGuiEventListener;
import java.util.AbstractList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiListExtendedNew<E extends IGuiListEntryNew<E>>
extends GuiSlotNew {
    private final List<E> entries = new UpdatingList();

    public GuiListExtendedNew(Minecraft mcIn, int widthIn, int heightIn, int topIn, int bottomIn, int slotHeightIn) {
        super(mcIn, widthIn, heightIn, topIn, bottomIn, slotHeightIn);
    }

    @Override
    protected boolean mouseClicked(int index, int button, double mouseX, double mouseY) {
        return this.getListEntry(index).mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected boolean isSelected(int slotIndex) {
        return false;
    }

    @Override
    protected void drawBackground() {
    }

    @Override
    protected void drawSlot(int slotIndex, int xPos, int yPos, int heightIn, int mouseXIn, int mouseYIn, float partialTicks) {
        ((IGuiListEntryNew)this.getListEntry(slotIndex)).drawEntry(this.getListWidth(), heightIn, mouseXIn, mouseYIn, this.isMouseInList(mouseXIn, mouseYIn) && this.getEntryAt(mouseXIn, mouseYIn) == slotIndex, partialTicks);
    }

    @Override
    protected void updateItemPos(int entryID, int insideLeft, int yPos, float partialTicks) {
        ((IGuiListEntryNew)this.getListEntry(entryID)).func_195000_a(partialTicks);
    }

    public final List<E> getChildren() {
        return this.entries;
    }

    protected final void clearEntries() {
        this.entries.clear();
    }

    private E getListEntry(int index) {
        return (E)((IGuiListEntryNew)this.getChildren().get(index));
    }

    protected final void addEntry(E entry) {
        this.entries.add(entry);
    }

    @Override
    public void setSelectedEntry(int index) {
        this.selectedElement = index;
        this.lastClicked = System.currentTimeMillis();
    }

    @Override
    protected final int getSize() {
        return this.getChildren().size();
    }

    @SideOnly(value=Side.CLIENT)
    class UpdatingList
    extends AbstractList<E> {
        private final List<E> innerList = Lists.newArrayList();

        private UpdatingList() {
        }

        @Override
        public E get(int p_get_1_) {
            return (IGuiListEntryNew)this.innerList.get(p_get_1_);
        }

        @Override
        public int size() {
            return this.innerList.size();
        }

        @Override
        public E set(int p_set_1_, E p_set_2_) {
            IGuiListEntryNew e = (IGuiListEntryNew)this.innerList.set(p_set_1_, p_set_2_);
            ((IGuiListEntryNew)p_set_2_).list = GuiListExtendedNew.this;
            ((IGuiListEntryNew)p_set_2_).index = p_set_1_;
            return e;
        }

        @Override
        public void add(int p_add_1_, E p_add_2_) {
            this.innerList.add(p_add_1_, p_add_2_);
            ((IGuiListEntryNew)p_add_2_).list = GuiListExtendedNew.this;
            ((IGuiListEntryNew)p_add_2_).index = p_add_1_;
            int i = p_add_1_ + 1;
            while (i < this.size()) {
                ((IGuiListEntryNew)this.get((int)i)).index = i++;
            }
        }

        @Override
        public E remove(int p_remove_1_) {
            IGuiListEntryNew e = (IGuiListEntryNew)this.innerList.remove(p_remove_1_);
            int i = p_remove_1_;
            while (i < this.size()) {
                ((IGuiListEntryNew)this.get((int)i)).index = i++;
            }
            return e;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static abstract class IGuiListEntryNew<E extends IGuiListEntryNew<E>>
    implements IGuiEventListener {
        protected GuiListExtendedNew<E> list;
        protected int index;

        protected GuiListExtendedNew<E> getList() {
            return this.list;
        }

        protected int getIndex() {
            return this.index;
        }

        protected int getY() {
            return this.list.top + 4 - this.list.getAmountScrolled() + this.index * this.list.slotHeight + this.list.headerPadding;
        }

        protected int getX() {
            return this.list.left + this.list.width / 2 - this.list.getListWidth() / 2 + 2;
        }

        protected void func_195000_a(float p_195000_1_) {
        }

        public abstract void drawEntry(int var1, int var2, int var3, int var4, boolean var5, float var6);
    }
}

