/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.shiftingwares;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.estecka.shiftingwares.ShiftingWaresMod;
import fr.estecka.shiftingwares.api.IShiftingTradeFactory;
import fr.estecka.shiftingwares.duck.ITradeOfferDuck;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_2960;
import net.minecraft.class_3853;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class ShiftingTradeData {
    public static final Codec<ShiftingTradeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("tradeId").forGetter(data -> Optional.ofNullable(data.tradeId)), (App)Codec.BOOL.fieldOf("isPersistent").orElse((Object)false).forGetter(data -> data.isPersistent), (App)Codec.BOOL.fieldOf("wasNeverUsed").orElse((Object)true).forGetter(data -> data.wasNeverUsed)).apply((Applicative)instance, ShiftingTradeData::new));
    @Nullable
    public class_2960 tradeId = null;
    public boolean isPersistent = false;
    public boolean wasNeverUsed = true;

    public ShiftingTradeData() {
    }

    public ShiftingTradeData(Optional<class_2960> tradeId, boolean isPersistent, boolean wasNeverUsed) {
        this.tradeId = tradeId.orElse(null);
        this.isPersistent = isPersistent;
        this.wasNeverUsed = wasNeverUsed;
    }

    public static void FinalizeTrade(@Nullable class_1914 offer, class_3853.class_1652 factory) {
        if (offer == null) {
            return;
        }
        IShiftingTradeFactory factoryData = IShiftingTradeFactory.Of(factory);
        ShiftingTradeData offerData = ITradeOfferDuck.Of(offer).shiftingwares$GetTradeData();
        offerData.isPersistent |= factoryData.shiftingwares$IsItemPersistent();
        class_2960 factoryId = factoryData.shiftingwares$GetTradeId();
        if (factoryId != null) {
            offerData.tradeId = factoryId;
        }
        class_1799 sellItem = offer.method_8250();
        if (!offerData.isPersistent && ShiftingTradeData.ShouldBePersistent(sellItem)) {
            offerData.isPersistent = true;
            ShiftingWaresMod.LOGGER.error("A trade factory just produced a persistent item, but did not declare it as such: {} ({})", (Object)sellItem.method_7964().getString(), (Object)sellItem.method_7909());
        } else if (offerData.isPersistent && factoryId != null) {
            ShiftingWaresMod.LOGGER.info("Created new persistent trade: {}", (Object)factoryId);
        }
    }

    public static boolean ShouldBePersistent(class_1799 stack) {
        return stack.method_57826(class_9334.field_49646);
    }
}

