/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.shiftingwares;

import fr.estecka.shiftingwares.ShiftingTradeData;
import fr.estecka.shiftingwares.ShiftingWaresMod;
import fr.estecka.shiftingwares.TradeLayouts.VanillaTradeLayout;
import fr.estecka.shiftingwares.api.IShiftingTradeFactory;
import fr.estecka.shiftingwares.api.ITradeLayoutProvider;
import fr.estecka.shiftingwares.duck.ITradeOfferDuck;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class TradeShuffler {
    public static final ITradeLayoutProvider VANILLA_LAYOUT = new VanillaTradeLayout();
    private final class_1646 villager;
    private final boolean depletedOnly;
    private final boolean keepPersistent;
    private final class_6880<class_3852> job;
    private final class_5819 random;
    private final class_1916 offers;
    private final List<class_3853.class_1652[]> tradeLayout;

    public TradeShuffler(class_1646 villager, boolean depletedOnly) {
        this.villager = villager;
        this.depletedOnly = depletedOnly;
        this.keepPersistent = !villager.method_5682().method_3767().method_8355(ShiftingWaresMod.MAP_RULE);
        this.offers = villager.method_8264();
        this.job = villager.method_7231().comp_3521();
        this.random = villager.method_59922();
        this.tradeLayout = TradeShuffler.GetTradeLayout(villager);
    }

    public static List<class_3853.class_1652[]> GetTradeLayout(class_1646 villager) {
        List providers = FabricLoader.getInstance().getEntrypoints("shifting-wares", ITradeLayoutProvider.class);
        for (ITradeLayoutProvider p : providers) {
            List<class_3853.class_1652[]> layout = p.GetTradeLayout(villager);
            if (layout == null) continue;
            return layout;
        }
        return VANILLA_LAYOUT.GetTradeLayout(villager);
    }

    public void Reroll() {
        if (this.tradeLayout == null) {
            ShiftingWaresMod.LOGGER.error("Missing layout, villager will not be rerolled: {} ({})", this.job, (Object)this.villager);
            return;
        }
        for (class_1914 offer : this.offers) {
            ShiftingTradeData data = ITradeOfferDuck.Of(offer).shiftingwares$GetTradeData();
            class_1799 sellItem = offer.method_8250();
            if (!data.isPersistent && ShiftingTradeData.ShouldBePersistent(sellItem)) {
                ShiftingWaresMod.LOGGER.warn("Caught an older unitialized persistent trade: {} ({})", (Object)sellItem.method_7964().getString(), (Object)sellItem.method_7909());
            }
            if (!offer.method_21834()) continue;
            data.wasNeverUsed = false;
        }
        for (int i = this.offers.size() - 1; this.tradeLayout.size() <= i; --i) {
            if (!this.shouldReroll(i)) continue;
            this.offers.remove(i);
        }
        while (this.offers.size() < this.tradeLayout.size()) {
            this.offers.add((Object)ShiftingWaresMod.PLACEHOLDER_TRADE);
        }
        this.DuplicataAwareReroll();
    }

    public boolean shouldReroll(int tradeIndex) {
        if (this.offers.size() <= tradeIndex) {
            return true;
        }
        class_1914 offer = (class_1914)this.offers.get(tradeIndex);
        ShiftingTradeData data = ITradeOfferDuck.Of(offer).shiftingwares$GetTradeData();
        if (data.isPersistent && (data.wasNeverUsed || this.keepPersistent)) {
            return false;
        }
        return !this.depletedOnly || offer.method_8255();
    }

    private static List<class_3853.class_1652>[] MutableCopy(List<class_3853.class_1652[]> layout) {
        IdentityHashMap mutablePools = new IdentityHashMap();
        mutablePools.put(null, new ArrayList(0));
        for (class_3853.class_1652[] pool : layout) {
            if (mutablePools.containsKey(pool)) continue;
            ArrayList<class_3853.class_1652> mpool = new ArrayList<class_3853.class_1652>(pool.length);
            for (class_3853.class_1652 f : pool) {
                mpool.add(f);
            }
            mutablePools.put(pool, mpool);
        }
        List[] workspace = new List[layout.size()];
        for (int i = 0; i < workspace.length; ++i) {
            workspace[i] = (List)mutablePools.get(layout.get(i));
        }
        return workspace;
    }

    private void DuplicataAwareReroll() {
        int i;
        List<class_3853.class_1652>[] mutableLayout = TradeShuffler.MutableCopy(this.tradeLayout);
        HashSet<class_2960> activeTrades = new HashSet<class_2960>();
        for (i = 0; i < this.offers.size(); ++i) {
            if (this.shouldReroll(i)) continue;
            ShiftingTradeData data = ITradeOfferDuck.Of((class_1914)this.offers.get(i)).shiftingwares$GetTradeData();
            if (data.tradeId == null) continue;
            activeTrades.add(data.tradeId);
        }
        for (i = 0; i < this.offers.size(); ++i) {
            if (!this.shouldReroll(i)) continue;
            class_3853.class_1652 factory = null;
            class_1914 offer = null;
            List<class_3853.class_1652> pool = mutableLayout[i];
            pool.removeIf(f -> {
                class_2960 tradeId = IShiftingTradeFactory.Of(f).shiftingwares$GetTradeId();
                return tradeId != null && activeTrades.contains(tradeId);
            });
            while (offer == null && !pool.isEmpty()) {
                int roll = this.random.method_43048(pool.size());
                factory = pool.get(roll);
                offer = factory.method_7246((class_1297)this.villager, this.random);
                pool.remove(roll);
            }
            if (offer == null) {
                offer = ShiftingWaresMod.PLACEHOLDER_TRADE;
            } else {
                ShiftingTradeData.FinalizeTrade(offer, factory);
                ShiftingTradeData data = ITradeOfferDuck.Of(offer).shiftingwares$GetTradeData();
                if (data.tradeId != null) {
                    activeTrades.add(data.tradeId);
                }
            }
            this.offers.set(i, (Object)offer);
        }
    }
}

