/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.shiftingwares.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import fr.estecka.shiftingwares.ShiftingWaresMod;
import fr.estecka.shiftingwares.TradeShuffler;
import fr.estecka.shiftingwares.mixin.IEntityAccessor;
import net.minecraft.class_1646;
import net.minecraft.class_1914;
import net.minecraft.class_1916;
import net.minecraft.class_1928;
import net.minecraft.class_3853;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Unique
@Mixin(value={class_1646.class})
public abstract class VillagerEntityMixin {
    private static final class_1916 EMPTY = new class_1916();
    private final class_1646 villager = (class_1646)this;

    private boolean IsDailyRerollEnabled() {
        return ((class_1928.class_4310)this.villager.method_5682().method_3767().method_20746(ShiftingWaresMod.DAILY_RULE)).method_20753();
    }

    private boolean IsDepleteRerollEnabled() {
        return ((class_1928.class_4310)this.villager.method_5682().method_3767().method_20746(ShiftingWaresMod.DEPLETED_RULE)).method_20753();
    }

    @Inject(method={"restockAndUpdateDemandBonus"}, at={@At(value="HEAD")})
    private void DailyReroll(CallbackInfo info) {
        if (this.IsDailyRerollEnabled()) {
            ShiftingWaresMod.LOGGER.info("A villager has restocked all their trades.");
            new TradeShuffler(this.villager, false).Reroll();
        } else if (this.IsDepleteRerollEnabled()) {
            ShiftingWaresMod.LOGGER.info("A villager has restocked some trades.");
            new TradeShuffler(this.villager, true).Reroll();
        }
    }

    @WrapOperation(method={"restockAndUpdateDemandBonus"}, at={@At(value="INVOKE", target="net/minecraft/entity/passive/VillagerEntity.getOffers ()Lnet/minecraft/village/TradeOfferList;")})
    private class_1916 DailyRefill(class_1646 me, Operation<class_1916> original) {
        if (this.IsDailyRerollEnabled() || this.IsDepleteRerollEnabled()) {
            return EMPTY;
        }
        return (class_1916)original.call(new Object[]{me});
    }

    @WrapOperation(method={"restock"}, at={@At(value="INVOKE", target="net/minecraft/entity/passive/VillagerEntity.getOffers ()Lnet/minecraft/village/TradeOfferList;")})
    private class_1916 RestockReroll(class_1646 me, Operation<class_1916> original) {
        if (this.IsDepleteRerollEnabled()) {
            ShiftingWaresMod.LOGGER.info("A villager has restocked some trades.");
            new TradeShuffler(this.villager, true).Reroll();
            return EMPTY;
        }
        return (class_1916)original.call(new Object[]{me});
    }

    @WrapOperation(method={"needsRestock"}, at={@At(value="INVOKE", target="net/minecraft/village/TradeOffer.hasBeenUsed ()Z")})
    private boolean RestockDepletedOnly(class_1914 offer, Operation<Boolean> hasBeenUsed) {
        return (Boolean)hasBeenUsed.call(new Object[]{offer}) != false && (offer.method_8255() || !this.IsDepleteRerollEnabled());
    }

    @WrapOperation(method={"fillRecipes"}, at={@At(value="INVOKE", target="net/minecraft/entity/passive/VillagerEntity.fillRecipesFromPool(Lnet/minecraft/village/TradeOfferList;[Lnet/minecraft/village/TradeOffers$Factory;I)V")})
    private void SetDeterministicRandom(class_1646 me, class_1916 list, class_3853.class_1652[] pool, int count, Operation<Void> original) {
        boolean isDeterministic = me.method_5682().method_3767().method_8355(ShiftingWaresMod.WORKSTATION_RULE);
        if (isDeterministic) {
            IEntityAccessor accessor = (IEntityAccessor)me;
            class_5819 originalRandom = me.method_59922();
            accessor.setRandom(class_5819.method_43049((long)me.method_5667().hashCode()));
            original.call(new Object[]{me, list, pool, count});
            accessor.setRandom(originalRandom);
        } else {
            original.call(new Object[]{me, list, pool, count});
        }
    }
}

