/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.column;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLDataException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Locale;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.column.StringColumn;
import org.mariadb.jdbc.client.util.MutableInt;
import org.mariadb.jdbc.util.CharsetEncodingLength;

public class BlobColumn
extends StringColumn
implements ColumnDecoder {
    public BlobColumn(ReadableByteBuf buf, int charset, long length, DataType dataType, byte decimals, int flags, int[] stringPos, String extTypeName, String extTypeFormat) {
        super(buf, charset, length, dataType, decimals, flags, stringPos, extTypeName, extTypeFormat);
    }

    protected BlobColumn(BlobColumn prev) {
        super(prev);
    }

    @Override
    public BlobColumn useAliasAsName() {
        return new BlobColumn(this);
    }

    @Override
    public String defaultClassname(Configuration conf) {
        return this.isBinary() ? Blob.class.getName() : String.class.getName();
    }

    @Override
    public int getColumnType(Configuration conf) {
        if (this.columnLength <= 0L || this.getDisplaySize() > 0xFFFFFF) {
            return this.isBinary() ? -4 : -1;
        }
        if (this.dataType == DataType.TINYBLOB || this.dataType == DataType.BLOB) {
            return this.isBinary() ? -3 : 12;
        }
        return this.isBinary() ? -4 : -1;
    }

    @Override
    public String getColumnTypeName(Configuration conf) {
        if (this.extTypeFormat != null) {
            return this.extTypeFormat.toUpperCase(Locale.ROOT);
        }
        if (this.isBinary()) {
            if (this.columnLength < 0L) {
                return "LONGBLOB";
            }
            if (this.columnLength <= 255L) {
                return "TINYBLOB";
            }
            if (this.columnLength <= 65535L) {
                return "BLOB";
            }
            if (this.columnLength <= 0xFFFFFFL) {
                return "MEDIUMBLOB";
            }
            return "LONGBLOB";
        }
        if (this.columnLength < 0L) {
            return "LONGTEXT";
        }
        if (this.getDisplaySize() <= 65532) {
            return "VARCHAR";
        }
        if (this.getDisplaySize() <= 65535) {
            return "TEXT";
        }
        if (this.getDisplaySize() <= 0xFFFFFF) {
            return "MEDIUMTEXT";
        }
        return "LONGTEXT";
    }

    @Override
    public int getPrecision() {
        if (!this.isBinary()) {
            Integer maxWidth2 = CharsetEncodingLength.maxCharlen.get(this.charset);
            if (maxWidth2 != null) {
                return (int)(this.columnLength / (long)maxWidth2.intValue());
            }
            return (int)this.columnLength / 4;
        }
        return (int)this.columnLength;
    }

    @Override
    public Object getDefaultText(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            return buf.readBlob(length.get());
        }
        return buf.readString(length.get());
    }

    @Override
    public Object getDefaultBinary(Configuration conf, ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.getDefaultText(conf, buf, length);
    }

    @Override
    public boolean decodeBooleanText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Boolean", new Object[]{this.dataType}));
        }
        String s2 = buf.readAscii(length.get());
        return !"0".equals(s2);
    }

    @Override
    public boolean decodeBooleanBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeBooleanText(buf, length);
    }

    @Override
    public byte decodeByteText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (!this.isBinary()) {
            long result;
            String str2 = buf.readString(length.get());
            try {
                result = new BigDecimal(str2).setScale(0, RoundingMode.DOWN).longValue();
            }
            catch (NumberFormatException nfe) {
                throw new SQLDataException(String.format("value '%s' (%s) cannot be decoded as Byte", new Object[]{str2, this.dataType}));
            }
            if ((long)((byte)result) != result) {
                throw new SQLDataException("byte overflow");
            }
            return (byte)result;
        }
        if (length.get() > 0) {
            byte b = buf.readByte();
            buf.skip(length.get() - 1);
            return b;
        }
        throw new SQLDataException("empty String value cannot be decoded as Byte");
    }

    @Override
    public byte decodeByteBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        return this.decodeByteText(buf, length);
    }

    @Override
    public String decodeStringText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public String decodeStringBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        return buf.readString(length.get());
    }

    @Override
    public short decodeShortText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
        }
        return super.decodeShortText(buf, length);
    }

    @Override
    public short decodeShortBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Short", new Object[]{this.dataType}));
        }
        return super.decodeShortBinary(buf, length);
    }

    @Override
    public int decodeIntText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
        }
        return super.decodeIntText(buf, length);
    }

    @Override
    public int decodeIntBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Integer", new Object[]{this.dataType}));
        }
        return super.decodeIntBinary(buf, length);
    }

    @Override
    public long decodeLongText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
        }
        return super.decodeLongText(buf, length);
    }

    @Override
    public long decodeLongBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Long", new Object[]{this.dataType}));
        }
        return super.decodeLongBinary(buf, length);
    }

    @Override
    public float decodeFloatText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
        }
        return super.decodeFloatText(buf, length);
    }

    @Override
    public float decodeFloatBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Float", new Object[]{this.dataType}));
        }
        return super.decodeFloatText(buf, length);
    }

    @Override
    public double decodeDoubleText(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
        }
        return super.decodeDoubleText(buf, length);
    }

    @Override
    public double decodeDoubleBinary(ReadableByteBuf buf, MutableInt length) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Double", new Object[]{this.dataType}));
        }
        return super.decodeDoubleBinary(buf, length);
    }

    @Override
    public Date decodeDateText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
        }
        return super.decodeDateText(buf, length, cal);
    }

    @Override
    public Date decodeDateBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Date", new Object[]{this.dataType}));
        }
        return super.decodeDateBinary(buf, length, cal);
    }

    @Override
    public Time decodeTimeText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
        }
        return super.decodeTimeText(buf, length, cal);
    }

    @Override
    public Time decodeTimeBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Time", new Object[]{this.dataType}));
        }
        return super.decodeTimeBinary(buf, length, cal);
    }

    @Override
    public Timestamp decodeTimestampText(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
        }
        return super.decodeTimestampText(buf, length, cal);
    }

    @Override
    public Timestamp decodeTimestampBinary(ReadableByteBuf buf, MutableInt length, Calendar cal) throws SQLDataException {
        if (this.isBinary()) {
            buf.skip(length.get());
            throw new SQLDataException(String.format("Data type %s cannot be decoded as Timestamp", new Object[]{this.dataType}));
        }
        return super.decodeTimestampBinary(buf, length, cal);
    }
}

