/*
 * Decompiled with CFR 0.152.
 */
package pethorses.config;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import pethorses.PetHorses;
import pethorses.config.ConfigManager;

public class LocalizationManager {
    private final PetHorses plugin;
    private FileConfiguration messages;

    public LocalizationManager(PetHorses plugin) {
        this.plugin = plugin;
        this.loadMessages();
    }

    private void loadMessages() {
        ConfigManager configManager = new ConfigManager(this.plugin);
        String lang = configManager.getLanguage();
        String fileName = "messages_" + lang + ".yml";
        File file = new File(this.plugin.getDataFolder(), fileName);
        if (!file.exists()) {
            this.plugin.saveResource(fileName, false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)file);
        InputStream defaultStream = this.plugin.getResource(fileName);
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.messages.setDefaults((Configuration)defaultConfig);
        }
    }

    public String getMessage(String key) {
        String message = this.messages.getString(key, "&cMissing translation: " + key);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }
}

