/*
 * Decompiled with CFR 0.152.
 */
package pethorses.listeners;

import java.util.UUID;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import pethorses.PetHorses;
import pethorses.inventory.MenuHolder;
import pethorses.services.HorseBackpackService;

public class BackpackInventoryListener
implements Listener {
    private final HorseBackpackService backpackService;

    public BackpackInventoryListener(PetHorses plugin) {
        this.backpackService = new HorseBackpackService(plugin);
    }

    @EventHandler
    public void onBackpackClose(InventoryCloseEvent event) {
        HumanEntity humanEntity = event.getPlayer();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!(event.getInventory().getHolder() instanceof MenuHolder)) {
            return;
        }
        MenuHolder holder = (MenuHolder)event.getInventory().getHolder();
        String id = holder.getId();
        if (id != null && id.startsWith("backpack_")) {
            UUID ownerUuid;
            String maybeUuid = id.substring("backpack_".length());
            try {
                ownerUuid = UUID.fromString(maybeUuid);
            }
            catch (Exception e) {
                ownerUuid = player.getUniqueId();
            }
            this.backpackService.saveBackpack(ownerUuid, event.getInventory());
        }
    }
}

