/*
 * Decompiled with CFR 0.152.
 */
package pethorses.menus;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import pethorses.PetHorses;
import pethorses.config.ConfigManager;
import pethorses.config.LocalizationManager;
import pethorses.inventory.MenuHolder;
import pethorses.services.HorseService;
import pethorses.storage.HorseData;

public class HorseStatsMenu {
    private static final int INVENTORY_SIZE = 27;
    private static final int SLOT_LEVEL = 10;
    private static final int SLOT_SPEED = 11;
    private static final int SLOT_HEALTH = 12;
    private static final int SLOT_JUMP = 13;
    private static final int SLOT_STATUS = 14;
    private static final int SLOT_TOTAL_BLOCKS = 16;
    private static final int SLOT_TOTAL_JUMPS = 17;

    public static void open(Player player, PetHorses plugin) {
        LocalizationManager lm = plugin.getLocalizationManager();
        HorseService horseService = plugin.getHorseService();
        HorseData data = horseService.getHorseData(player.getUniqueId());
        ConfigManager cfg = plugin.getConfigManager();
        MenuHolder holder = new MenuHolder("stats");
        Inventory inv = Bukkit.createInventory((InventoryHolder)holder, (int)27, (Component)Component.text((String)lm.getMessage("menu.stats.title")));
        HorseStatsMenu.setMenuItem(inv, 10, Material.EXPERIENCE_BOTTLE, lm.getMessage("menu.stats.level").replace("{level}", String.valueOf(data.getLevel())), Arrays.asList(lm.getMessage("menu.stats.experience").replace("{current}", HorseStatsMenu.formatNumber(data.getExperience())).replace("{required}", HorseStatsMenu.formatNumber(horseService.getXpRequiredForNextLevel(data.getLevel()))), lm.getMessage("menu.stats.xp_to_next").replace("{remaining}", HorseStatsMenu.formatNumber(horseService.getXpRequiredForNextLevel(data.getLevel()) - data.getExperience()))));
        double speedAttr = cfg.getSpeedBase() + cfg.getSpeedMaxBonus() * ((double)data.getLevel() / 20.0);
        double speedBps = speedAttr * 43.0;
        HorseStatsMenu.setMenuItem(inv, 11, Material.SUGAR, lm.getMessage("menu.stats.speed").replace("{value}", String.format("%.2f", speedAttr)).replace("{bps}", String.format("%.2f", speedBps)), null);
        HorseStatsMenu.setMenuItem(inv, 12, Material.APPLE, lm.getMessage("menu.stats.health").replace("{value}", String.format("%.1f", 15.0 + 15.0 * ((double)data.getLevel() / 20.0))), null);
        double jumpAttr = cfg.getJumpBase() + cfg.getJumpMaxBonus() * ((double)data.getLevel() / 20.0);
        double jumpBlocks = jumpAttr * 1.8;
        HorseStatsMenu.setMenuItem(inv, 13, Material.RABBIT_FOOT, lm.getMessage("menu.stats.jump_strength").replace("{value}", String.format("%.2f", jumpAttr)).replace("{height}", String.format("%.2f", jumpBlocks)), null);
        boolean isOnCooldown = horseService.isOnCooldown(data);
        HorseStatsMenu.setMenuItem(inv, 14, isOnCooldown ? Material.REDSTONE : Material.LIME_DYE, isOnCooldown ? lm.getMessage("menu.stats.status_cooldown") : lm.getMessage("menu.stats.status_ready"), isOnCooldown ? List.of(lm.getMessage("menu.stats.cooldown_remaining").replace("{time}", horseService.getCooldownLeftFormatted(data))) : null);
        HorseStatsMenu.setMenuItem(inv, 16, Material.FILLED_MAP, lm.getMessage("menu.stats.total_blocks").replace("{value}", HorseStatsMenu.formatNumber(data.getTotalBlocksTraveled())), List.of(lm.getMessage("menu.stats.total_blocks_description")));
        HorseStatsMenu.setMenuItem(inv, 17, Material.FEATHER, lm.getMessage("menu.stats.total_jumps").replace("{value}", HorseStatsMenu.formatNumber(data.getTotalJumps())), List.of(lm.getMessage("menu.stats.total_jumps_description")));
        player.openInventory(inv);
    }

    private static void setMenuItem(Inventory inv, int slot, Material material, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.displayName((Component)Component.text((String)displayName));
            if (lore != null) {
                ArrayList<TextComponent> lc = new ArrayList<TextComponent>();
                for (String s2 : lore) {
                    lc.add(Component.text((String)s2));
                }
                meta.lore(lc);
            }
            item.setItemMeta(meta);
        }
        inv.setItem(slot, item);
    }

    private static String formatNumber(double number) {
        if (number < 1000.0) {
            return String.format("%.0f", number);
        }
        if (number < 1000000.0) {
            return String.format("%.1f\u043a", number / 1000.0).replace(".0", "");
        }
        return String.format("%.1f\u043a\u043a", number / 1000000.0).replace(".0", "");
    }

    private static String formatNumber(int number) {
        return HorseStatsMenu.formatNumber((double)number);
    }
}

