/*
 * Decompiled with CFR 0.152.
 */
package pethorses.services;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import pethorses.PetHorses;
import pethorses.config.ConfigManager;
import pethorses.inventory.MenuHolder;
import pethorses.storage.HorseData;

public class HorseBackpackService {
    private final PetHorses plugin;
    private final ConfigManager configManager;

    public HorseBackpackService(PetHorses plugin) {
        this.plugin = plugin;
        this.configManager = plugin.getConfigManager();
    }

    public void openBackpack(Player player, Horse horse) {
        if (!horse.isTamed() || horse.getOwner() == null || !horse.getOwner().getUniqueId().equals(player.getUniqueId())) {
            player.sendMessage(this.plugin.getLocalizationManager().getMessage("horse.not_yours"));
            return;
        }
        HorseData data = this.plugin.getHorseService().getHorseData(player.getUniqueId());
        int backpackSize = data.getBackpackSize(this.configManager.getBackpackBaseSize(), this.configManager.getBackpackSizePerLevel(), this.configManager.getBackpackMaxSize());
        MenuHolder holder = new MenuHolder("backpack_" + player.getUniqueId().toString());
        Inventory backpack = Bukkit.createInventory((InventoryHolder)holder, (int)backpackSize, (Component)Component.text((String)this.plugin.getLocalizationManager().getMessage("menu.backpack.title")));
        if (data.getBackpackItems() != null && data.getBackpackItems().length > 0) {
            for (int i = 0; i < Math.min(data.getBackpackItems().length, backpackSize); ++i) {
                backpack.setItem(i, data.getBackpackItems()[i]);
            }
        }
        player.openInventory(backpack);
    }

    public void saveBackpack(UUID playerId, Inventory inventory) {
        HorseData data = this.plugin.getHorseService().getHorseData(playerId);
        ItemStack[] items = new ItemStack[inventory.getSize()];
        for (int i = 0; i < inventory.getSize(); ++i) {
            items[i] = inventory.getItem(i);
        }
        data.setBackpackItems(items);
        this.plugin.getHorseDataManager().saveHorseData(data);
    }

    public void handleArmorForHorse(Horse horse, HorseData data) {
        if (this.configManager.isArmorSlotEnabled() && data.getArmorItem() != null) {
            horse.getInventory().setArmor(data.getArmorItem());
        }
    }

    public void saveHorseArmor(UUID playerId, ItemStack armor) {
        if (this.configManager.isArmorSlotEnabled()) {
            HorseData data = this.plugin.getHorseService().getHorseData(playerId);
            data.setArmorItem(armor);
            this.plugin.getHorseDataManager().saveHorseData(data);
        }
    }

    public void saveHorseArmorFromEntity(UUID playerId, Horse horse) {
        if (this.configManager.isArmorSlotEnabled() && horse != null) {
            HorseData data = this.plugin.getHorseService().getHorseData(playerId);
            data.setArmorItem(horse.getInventory().getArmor());
            this.plugin.getHorseDataManager().saveHorseData(data);
        }
    }
}

