/*
 * Decompiled with CFR 0.152.
 */
package pethorses.services;

import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import pethorses.PetHorses;
import pethorses.config.ConfigManager;
import pethorses.services.HorseBackpackService;
import pethorses.storage.HorseData;
import pethorses.storage.HorseDataManager;

public class HorseService {
    private final PetHorses plugin;
    private final HorseDataManager dataManager;
    private final ConfigManager configManager;
    private final HorseBackpackService backpackService;

    public HorseService(PetHorses plugin) {
        this.plugin = plugin;
        this.dataManager = plugin.getHorseDataManager();
        this.configManager = plugin.getConfigManager();
        this.backpackService = new HorseBackpackService(plugin);
    }

    public void summonHorse(Player player) {
        UUID playerId = player.getUniqueId();
        HorseData data = this.getHorseData(playerId);
        if (this.isOnCooldown(data)) {
            player.sendMessage(this.plugin.getLocalizationManager().getMessage("horse.cooldown_active").replace("{time}", this.getCooldownLeftFormatted(data)));
            return;
        }
        this.hideHorse(data);
        data.setOwnerId(playerId);
        Horse horse = this.spawnHorse(player.getLocation(), player, data);
        this.setFollowing(data, true);
        if (data.isFollowing()) {
            this.makeHorseFollow(player, data, horse);
        }
    }

    private Horse spawnHorse(Location location, Player owner, HorseData data) {
        Horse horse = (Horse)owner.getWorld().spawnEntity(location, EntityType.HORSE);
        horse.setOwner((AnimalTamer)owner);
        horse.setTamed(true);
        horse.setAdult();
        horse.setCanPickupItems(false);
        horse.getInventory().setSaddle(new ItemStack(Material.SADDLE));
        this.backpackService.handleArmorForHorse(horse, data);
        horse.setColor(data.getColor());
        horse.setStyle(data.getStyle());
        if (data.getHorseName() != null && !data.getHorseName().isEmpty()) {
            NamedTextColor ntc = data.getHorseNameColor();
            Component comp = Component.text((String)data.getHorseName()).color((TextColor)(ntc != null ? ntc : NamedTextColor.WHITE));
            horse.customName(comp);
            horse.setCustomNameVisible(true);
        }
        this.applyHorseStats(horse, data);
        data.setHorseId(horse.getUniqueId());
        return horse;
    }

    public void applyHorseStats(Horse horse, HorseData data) {
        int level = data.getLevel();
        AttributeInstance attrSpeed = horse.getAttribute(Attribute.GENERIC_MOVEMENT_SPEED);
        if (attrSpeed != null) {
            attrSpeed.setBaseValue(this.configManager.getSpeedBase() + this.configManager.getSpeedMaxBonus() * ((double)level / 20.0));
        }
        double maxHealth = this.configManager.getHealthBase() + this.configManager.getHealthMaxBonus() * ((double)level / 20.0);
        AttributeInstance attrHealth = horse.getAttribute(Attribute.GENERIC_MAX_HEALTH);
        if (attrHealth != null) {
            attrHealth.setBaseValue(maxHealth);
        }
        horse.setHealth(Math.min(maxHealth, horse.getAttribute(Attribute.GENERIC_MAX_HEALTH) != null ? horse.getAttribute(Attribute.GENERIC_MAX_HEALTH).getBaseValue() : maxHealth));
        AttributeInstance attrJump = horse.getAttribute(Attribute.GENERIC_JUMP_STRENGTH);
        if (attrJump != null) {
            attrJump.setBaseValue(this.configManager.getJumpBase() + this.configManager.getJumpMaxBonus() * ((double)level / 20.0));
        }
        data.setJumps(0);
        data.setBlocksTraveled(0.0);
        if (data.getHorseName() != null && !data.getHorseName().isEmpty()) {
            NamedTextColor ntc = data.getHorseNameColor();
            Component comp = Component.text((String)data.getHorseName()).color((TextColor)(ntc != null ? ntc : NamedTextColor.WHITE));
            horse.customName(comp);
            horse.setCustomNameVisible(true);
        }
    }

    public void makeHorseFollow(final Player player, final HorseData data, final Horse horse) {
        horse.getPathfinder().stopPathfinding();
        new BukkitRunnable(this){

            public void run() {
                double speed;
                if (!data.isFollowing() || horse.isDead() || !player.isOnline()) {
                    this.cancel();
                    return;
                }
                Location playerLoc = player.getLocation();
                Location horseLoc = horse.getLocation();
                double distance = horseLoc.distance(playerLoc);
                double d = speed = player.isSprinting() ? 2.5 : 1.5;
                if (distance > 10.0) {
                    horse.teleport(playerLoc);
                } else if (distance > 2.0) {
                    Vector direction = playerLoc.toVector().subtract(horseLoc.toVector()).normalize();
                    Location targetLoc = playerLoc.clone().subtract(direction.multiply(2));
                    horse.getPathfinder().moveTo(targetLoc, speed);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }

    public void hideHorse(HorseData data) {
        if (data == null || data.getHorseId() == null) {
            return;
        }
        Entity entity = Bukkit.getEntity((UUID)data.getHorseId());
        if (entity instanceof Horse) {
            Horse horse = (Horse)entity;
            this.backpackService.saveHorseArmorFromEntity(data.getOwnerId(), horse);
        }
        if (entity != null) {
            entity.remove();
        }
        data.setHorseId(null);
    }

    public void onHorseDeath(UUID playerId, Horse horse) {
        final HorseData data = this.getHorseData(playerId);
        if (data == null) {
            return;
        }
        if (this.configManager.isBackpackDropOnDeath()) {
            this.dropBackpackItems(horse, data);
            data.setBackpackItems(new ItemStack[0]);
        }
        this.backpackService.saveHorseArmorFromEntity(playerId, horse);
        data.setDeathTime(System.currentTimeMillis());
        data.setHorseId(null);
        new BukkitRunnable(this){
            final /* synthetic */ HorseService this$0;
            {
                this.this$0 = this$0;
            }

            public void run() {
                this.this$0.dataManager.saveHorseData(data);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void dropBackpackItems(Horse horse, HorseData data) {
        ItemStack[] items = data.getBackpackItems();
        if (items == null) {
            return;
        }
        for (ItemStack item : items) {
            if (item == null || item.getType() == Material.AIR) continue;
            horse.getWorld().dropItem(horse.getLocation(), item);
        }
    }

    public boolean isOnCooldown(HorseData data) {
        if (data == null) {
            return false;
        }
        long cooldownDuration = this.configManager.getRespawnCooldownMinutes() * 60L * 1000L;
        return System.currentTimeMillis() - data.getDeathTime() < cooldownDuration;
    }

    public String getCooldownLeftFormatted(HorseData data) {
        if (data == null) {
            return "00:00";
        }
        long left = (this.configManager.getRespawnCooldownMinutes() * 60L * 1000L - (System.currentTimeMillis() - data.getDeathTime())) / 1000L;
        long minutes = left / 60L;
        long seconds = left % 60L;
        return String.format("%02d:%02d", minutes, seconds);
    }

    public void addJump(UUID playerId) {
        HorseData data = this.getHorseData(playerId);
        if (data == null) {
            return;
        }
        data.setJumps(data.getJumps() + 1);
        data.setTotalJumps(data.getTotalJumps() + 1);
        if (data.getJumps() >= 10) {
            int xpToAdd = data.getJumps() / 10;
            data.setJumps(data.getJumps() % 10);
            this.addExperience(data, xpToAdd);
        }
    }

    public void addTraveledBlocks(UUID playerId, double distance) {
        HorseData data = this.getHorseData(playerId);
        if (data == null) {
            return;
        }
        data.setBlocksTraveled(data.getBlocksTraveled() + distance);
        data.setTotalBlocksTraveled(data.getTotalBlocksTraveled() + distance);
        if (data.getBlocksTraveled() >= 5.0) {
            int xpToAdd = (int)(data.getBlocksTraveled() / 5.0);
            data.setBlocksTraveled(data.getBlocksTraveled() % 5.0);
            this.addExperience(data, xpToAdd);
        }
    }

    private void addExperience(HorseData data, int amount) {
        data.setExperience(data.getExperience() + amount);
        int requiredExp = this.getXpRequiredForNextLevel(data.getLevel());
        if (data.getExperience() >= requiredExp) {
            data.setLevel(data.getLevel() + 1);
            data.setExperience(data.getExperience() - requiredExp);
            Player player = Bukkit.getPlayer((UUID)data.getOwnerId());
            if (player != null) {
                Entity entity;
                player.sendMessage(this.plugin.getLocalizationManager().getMessage("horse.level_up").replace("{level}", String.valueOf(data.getLevel())));
                if (data.getHorseId() != null && (entity = Bukkit.getEntity((UUID)data.getHorseId())) instanceof Horse) {
                    Horse horse = (Horse)entity;
                    Location loc = horse.getLocation();
                    horse.getWorld().spawnParticle(Particle.HAPPY_VILLAGER, loc.add(0.0, 1.0, 0.0), 20, 0.5, 0.5, 0.5, 0.1);
                    this.applyHorseStats(horse, data);
                }
            }
        }
    }

    public int getXpRequiredForNextLevel(int currentLevel) {
        return this.configManager.getBaseXpForLevel() + currentLevel * this.configManager.getXpIncrementPerLevel();
    }

    public HorseData getHorseData(UUID playerId) {
        return this.dataManager.getHorseData(playerId);
    }

    public void setFollowing(HorseData data, boolean following) {
        if (data != null) {
            data.setFollowing(following);
        }
    }

    public void saveHorseArmor(UUID playerId, ItemStack armor) {
        this.backpackService.saveHorseArmor(playerId, armor);
    }
}

