/*
 * Decompiled with CFR 0.152.
 */
package pethorses.services;

import java.util.Set;
import java.util.UUID;
import pethorses.PetHorses;
import pethorses.storage.HorseDataManager;

public class PassengerService {
    private final HorseDataManager dataManager;

    public PassengerService(PetHorses plugin) {
        this.dataManager = plugin.getHorseDataManager();
    }

    public boolean hasPermission(UUID ownerUUID, UUID passengerUUID) {
        return this.dataManager.getPassengers(ownerUUID).contains(passengerUUID);
    }

    public void addPermission(UUID ownerUUID, UUID passengerUUID) {
        this.dataManager.addPassenger(ownerUUID, passengerUUID);
    }

    public void removePermission(UUID ownerUUID, UUID passengerUUID) {
        this.dataManager.removePassenger(ownerUUID, passengerUUID);
    }

    public Set<UUID> getPassengers(UUID ownerUUID) {
        return this.dataManager.getPassengers(ownerUUID);
    }
}

